/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.mt.impl;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.mt.MtAsyncUnsubscribeEventContext;
import com.sap.cds.services.mt.MtUnsubscribeEventContext;
import com.sap.cloud.mt.runtime.TenantAwareDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"MtSubscriptionService$Default"})
public class MtUnsubscriptionClearDatasourceHandler
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(MtUnsubscriptionClearDatasourceHandler.class);
    private final TenantAwareDataSource dataSource;

    public MtUnsubscriptionClearDatasourceHandler(TenantAwareDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @After
    protected void afterUnsubscribe(MtUnsubscribeEventContext context) {
        if (context.getDelete() != null && context.getDelete().booleanValue()) {
            this.removeDataSourceFromCache(context, context.getTenantId());
        }
    }

    @After
    protected void afterUnsubscribeAsync(MtAsyncUnsubscribeEventContext context) {
        if (context.getDelete() != null && context.getDelete().booleanValue()) {
            this.removeDataSourceFromCache(context, context.getTenantId());
        }
    }

    private void removeDataSourceFromCache(EventContext context, String tenantId) {
        if (this.dataSource != null) {
            log.debug("Removing data source of tenant '{}' from cache", (Object)tenantId);
            this.dataSource.deleteFromCache(tenantId);
        }
    }
}

