/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.google.common.base.Objects;
import com.sap.cds.integration.cloudsdk.rest.client.JsonRestClient;
import com.sap.cds.services.environment.ServiceBinding;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaasClient
extends JsonRestClient {
    private static final Logger logger = LoggerFactory.getLogger(SaasClient.class);
    private static final int PAGE_SIZE = 500;
    private static final String TENANT_STATE = "state";
    private static final String SAAS_REGISTRY = "saas-registry";
    private static final String SAAS_MANAGER_BASE = "/saas-manager/v1/";
    private static final String APPLICATION_TENANTS_PATH = "/saas-manager/v1/application/subscriptions";
    private static final String SERVICE_TENANTS_PATH = "/saas-manager/v1/service/subscriptions?includeIndirectSubscriptions=true";
    private final String urlPath;

    public static Optional<ServiceBinding> findBinding(CdsRuntime runtime) {
        return runtime.getEnvironment().getServiceBindings().filter(b -> b.matches(null, SAAS_REGISTRY)).findFirst();
    }

    public SaasClient(ServiceBinding binding) {
        super(SaasClient.getSaasUrl(binding), SaasClient.checkBinding(binding), OnBehalfOf.TECHNICAL_USER_PROVIDER);
        this.urlPath = "service".equals(binding.getServicePlan()) ? SERVICE_TENANTS_PATH : APPLICATION_TENANTS_PATH;
    }

    public List<Map<String, Object>> getSubscribedTenants() throws IOException {
        logger.debug("Retrieving all tenants metadata from the SaaS registry");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        boolean morePages = true;
        int page = 1;
        while (morePages) {
            logger.debug("Retrieving page {} of all tenants metadata from the SaaS registry", (Object)page);
            String paginatedUrlPath = this.paginatedUrl(this.urlPath, page);
            JsonNode jsonResponse = this.getRequest(paginatedUrlPath);
            ArrayNode resp = (ArrayNode)this.getNode(jsonResponse, "subscriptions");
            BooleanNode morePagesResp = (BooleanNode)this.getNode(jsonResponse, "morePages");
            resp.forEach(tenant -> {
                String state;
                String string = state = tenant.get(TENANT_STATE) != null ? tenant.get(TENANT_STATE).asText() : null;
                if (Objects.equal((Object)state, (Object)"SUBSCRIBED") || Objects.equal((Object)state, (Object)"UPDATE_FAILED")) {
                    result.add((Map<String, Object>)this.mapper.convertValue(tenant, (TypeReference)new TypeReference<Map<String, Object>>(){}));
                }
            });
            morePages = morePagesResp != null && morePagesResp.booleanValue();
            ++page;
            logger.debug("More tenants metadata from the SaaS registry available: {}", (Object)(morePages ? "yes" : "no"));
        }
        return result;
    }

    private String paginatedUrl(String urlPath, int page) {
        String url = urlPath + (urlPath.contains("?") ? "&" : "?");
        url = url + "page=" + page + "&size=" + 500;
        return url;
    }

    private <N> N getNode(JsonNode jsonResponse, String keyName) {
        return (N)jsonResponse.get(keyName);
    }

    private static String getSaasUrl(ServiceBinding binding) {
        return binding.getCredentials().get("saas_registry_url").toString();
    }

    private static ServiceBinding checkBinding(final ServiceBinding binding) {
        if (binding.getCredentials().get("uaa") == null) {
            return new ServiceBinding(){

                public List<String> getTags() {
                    return binding.getTags();
                }

                public String getServicePlan() {
                    return binding.getServicePlan();
                }

                public String getService() {
                    return binding.getService();
                }

                public String getName() {
                    return binding.getName();
                }

                public Map<String, Object> getCredentials() {
                    HashMap<String, Object> credentials = new HashMap<String, Object>();
                    binding.getCredentials().forEach(credentials::put);
                    credentials.put("uaa", binding.getCredentials());
                    return credentials;
                }
            };
        }
        return binding;
    }
}

