/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.mt.impl;

import com.sap.cds.feature.mt.MtUtils;
import com.sap.cds.feature.mt.SaasClient;
import com.sap.cds.services.Service;
import com.sap.cds.services.environment.ServiceBinding;
import com.sap.cds.services.mt.impl.ExtensibilityServiceImpl;
import com.sap.cds.services.mt.impl.MtDeploymentServiceHandler;
import com.sap.cds.services.mt.impl.MtSubscriptionServiceCompatibilityHandler;
import com.sap.cds.services.mt.impl.MtSubscriptionServiceImpl;
import com.sap.cds.services.mt.impl.MtTenantProviderHandler;
import com.sap.cds.services.mt.impl.MtTenantProviderSaasHandler;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.utils.model.DynamicModelUtils;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import java.util.Optional;

public class MtDeploymentServiceConfiguration
implements CdsRuntimeConfiguration {
    public void services(CdsRuntimeConfigurer configurer) {
        boolean compatibility = configurer.getCdsRuntime().getEnvironment().getCdsProperties().getMultiTenancy().getCompatibility().isEnabled();
        if (new MtUtils(configurer.getCdsRuntime()).requiresSubscription() && compatibility) {
            configurer.service((Service)new MtSubscriptionServiceImpl("MtSubscriptionService$Default"));
        }
        if (new DynamicModelUtils(configurer.getCdsRuntime()).isDynamicModelEnabled()) {
            configurer.service((Service)new ExtensibilityServiceImpl("ExtensibilityService$Default"));
        }
    }

    public void eventHandlers(CdsRuntimeConfigurer configurer) {
        MtUtils mtUtils = new MtUtils(configurer.getCdsRuntime());
        InstanceLifecycleManager ilm = mtUtils.createDefaultInstanceLifecycleManager();
        Optional<ServiceBinding> saasBinding = SaasClient.findBinding(configurer.getCdsRuntime());
        if (saasBinding.isPresent()) {
            configurer.eventHandler((Object)new MtTenantProviderSaasHandler(saasBinding.get()));
        }
        if (ilm != null) {
            configurer.eventHandler((Object)new MtTenantProviderHandler(ilm));
        }
        if (mtUtils.requiresSubscription()) {
            boolean compatibility = configurer.getCdsRuntime().getEnvironment().getCdsProperties().getMultiTenancy().getCompatibility().isEnabled();
            if (compatibility) {
                configurer.eventHandler((Object)new MtSubscriptionServiceCompatibilityHandler(ilm, configurer.getCdsRuntime()));
            } else {
                configurer.eventHandler((Object)new MtDeploymentServiceHandler(ilm, configurer.getCdsRuntime()));
            }
            configurer.getCdsRuntime().getEnvironment().getCdsProperties().getOutbox().getPersistent().getProviderTenant().setEnabled(Boolean.valueOf(false));
        }
    }
}

