/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.mt.impl;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.mt.DependenciesEventContext;
import com.sap.cds.services.mt.MtAsyncDeployEventContext;
import com.sap.cds.services.mt.MtAsyncDeployStatusEventContext;
import com.sap.cds.services.mt.MtAsyncSubscribeEventContext;
import com.sap.cds.services.mt.MtAsyncSubscribeFinishedEventContext;
import com.sap.cds.services.mt.MtAsyncUnsubscribeEventContext;
import com.sap.cds.services.mt.MtAsyncUnsubscribeFinishedEventContext;
import com.sap.cds.services.mt.MtDeployEventContext;
import com.sap.cds.services.mt.MtGetDependenciesEventContext;
import com.sap.cds.services.mt.MtSubscribeEventContext;
import com.sap.cds.services.mt.MtSubscriptionService;
import com.sap.cds.services.mt.MtUnsubscribeEventContext;
import com.sap.cds.services.mt.SaasRegistryDependency;
import com.sap.cds.services.mt.SubscribeEventContext;
import com.sap.cds.services.mt.UnsubscribeEventContext;
import com.sap.cds.services.mt.UpgradeEventContext;
import com.sap.cds.services.mt.impl.MtDeploymentServiceHandler;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.SubscriberImpl;
import com.sap.cloud.mt.subscription.exceptions.AuthorityError;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.NotFound;
import com.sap.cloud.mt.subscription.exceptions.NotSupported;
import com.sap.cloud.mt.subscription.exceptions.ParameterError;
import com.sap.cloud.mt.subscription.json.ApplicationDependency;
import com.sap.cloud.mt.subscription.json.DeletePayload;
import com.sap.cloud.mt.subscription.json.SidecarSubscribeCallBackPayload;
import com.sap.cloud.mt.subscription.json.SidecarSubscriptionPayload;
import com.sap.cloud.mt.subscription.json.SidecarUnSubscribeCallBackPayload;
import com.sap.cloud.mt.subscription.json.SidecarUnSubscriptionPayload;
import com.sap.cloud.mt.subscription.json.SidecarUpgradePayload;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;
import com.sap.xsa.core.instancemanager.client.InstanceCreationOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtSubscriptionServiceCompatibilityHandler
extends MtDeploymentServiceHandler {
    public static final String PARAM_APPLICATION_URL = "_internal_applicationUrlFromJava";
    private static final String PARAM_UPGRADE_COMPATIBILITY = "_internal_upgradeCompatibilityMode";
    private static final Logger logger = LoggerFactory.getLogger(MtSubscriptionServiceCompatibilityHandler.class);
    private static final String SUCCEEDED = "SUCCEEDED";
    private static final String FAILED = "FAILED";
    private final MtSubscriptionService service;
    private final String callbackScope;
    private final String deployScope;

    public MtSubscriptionServiceCompatibilityHandler(InstanceLifecycleManager instanceLifecycleManager, CdsRuntime runtime) {
        super(instanceLifecycleManager, runtime);
        this.service = (MtSubscriptionService)runtime.getServiceCatalog().getService(MtSubscriptionService.class, "MtSubscriptionService$Default");
        this.callbackScope = runtime.getEnvironment().getCdsProperties().getMultiTenancy().getSecurity().getSubscriptionScope();
        this.deployScope = runtime.getEnvironment().getCdsProperties().getMultiTenancy().getSecurity().getDeploymentScope();
    }

    @Before(service={"MtSubscriptionService$Default"}, event={"SUBSCRIBE", "UNSUBSCRIBE", "ASYNC_SUBSCRIBE", "ASYNC_UNSUBSCRIBE", "ASYNC_SUBSCRIBE_FINISHED", "ASYNC_UNSUBSCRIBE_FINISHED", "GET_DEPENDENCIES"})
    @HandlerOrder(value=-10900)
    protected void checkAuthorization(EventContext context) {
        if (!context.getUserInfo().isPrivileged() && !context.getUserInfo().hasRole(this.callbackScope)) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[0]);
        }
    }

    @Before(service={"MtSubscriptionService$Default"}, event={"DEPLOY", "ASYNC_DEPLOY", "ASYNC_DEPLOY_STATUS"})
    @HandlerOrder(value=-10900)
    protected void checkAuthorizationDeployment(EventContext context) {
        if (!context.getUserInfo().isPrivileged() && !context.getUserInfo().hasRole(this.deployScope)) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[0]);
        }
    }

    @On(service={"MtSubscriptionService$Default"})
    @HandlerOrder(value=11000)
    protected void onGetDependencies(MtGetDependenciesEventContext context) {
        context.setResult(new ArrayList<ApplicationDependency>());
    }

    @On
    @HandlerOrder(value=10900)
    private void defaultDependencies(DependenciesEventContext context) {
        context.setResult(this.service.getDependencies().stream().map(a -> {
            SaasRegistryDependency d = SaasRegistryDependency.create();
            if (a.xsappname != null) {
                d.setXsappname(a.xsappname);
            }
            if (a.appId != null) {
                d.setAppId(a.appId);
            }
            if (a.appName != null) {
                d.setAppName(a.appName);
            }
            return d;
        }).collect(Collectors.toList()));
    }

    @On(service={"MtSubscriptionService$Default"})
    @HandlerOrder(value=11000)
    protected void onSubscribe(MtSubscribeEventContext context) {
        try {
            this.options.set(context.getInstanceCreationOptions());
            context.setResult(this.subscriber.subscribe(context.getTenantId(), context.getSubscriptionPayload(), this.forwardToken(context)));
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SUBSCRIPTION_FAILED, new Object[]{context.getTenantId(), e});
        }
        catch (ParameterError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[]{e});
        }
        catch (AuthorityError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[]{e});
        }
        finally {
            this.options.remove();
        }
    }

    @On(service={"MtSubscriptionService$Default"})
    @HandlerOrder(value=11000)
    protected void onSubscribeAsync(MtAsyncSubscribeEventContext context) {
        SidecarSubscribeCallBackPayload payload = new SidecarSubscribeCallBackPayload();
        payload.tenantId = context.getTenantId();
        payload.saasRequestPayload = new SidecarSubscriptionPayload(context.getSubscriptionPayload());
        payload.saasCallbackUrl = context.getSaasRegistryCallbackUrl();
        try {
            MtSubscribeEventContext syncContext = MtSubscribeEventContext.create();
            syncContext.setTenantId(context.getTenantId());
            syncContext.setSubscriptionPayload(context.getSubscriptionPayload());
            syncContext.setInstanceCreationOptions(context.getInstanceCreationOptions());
            this.onSubscribe(syncContext);
            payload.saasRequestPayload._applicationUrlFromJava_ = syncContext.getResult();
            payload.status = SUCCEEDED;
            payload.message = "Subscription succeeded";
            context.setResult("");
        }
        catch (Exception e) {
            payload.status = FAILED;
            payload.message = "Subscription failed";
            throw e;
        }
        finally {
            this.service.finishAsyncSubscribe(payload);
            context.put(PARAM_APPLICATION_URL, payload.saasRequestPayload._applicationUrlFromJava_);
        }
    }

    @On(service={"MtSubscriptionService$Default"})
    @HandlerOrder(value=11000)
    protected void onSubscribeAsyncFinished(MtAsyncSubscribeFinishedEventContext context) {
        context.setCompleted();
    }

    @Override
    protected void onSubscribe(SubscribeEventContext context) {
        SubscriptionPayload payload = (SubscriptionPayload)mapper.convertValue((Object)context.getOptions(), SubscriptionPayload.class);
        InstanceCreationOptions ico = this.buildInstanceCreationOptions(context);
        String callbackUrl = context.getParameterInfo().getHeader("STATUS_CALLBACK");
        if (StringUtils.isEmpty((String)callbackUrl)) {
            MtSubscribeEventContext mtContext = MtSubscribeEventContext.create();
            mtContext.setSubscriptionPayload(payload);
            mtContext.setTenantId(context.getTenant());
            mtContext.setInstanceCreationOptions(ico);
            this.service.emit(mtContext);
            context.getOptions().put(PARAM_APPLICATION_URL, mtContext.getResult());
        } else {
            MtAsyncSubscribeEventContext mtContext = MtAsyncSubscribeEventContext.create();
            mtContext.setSubscriptionPayload(payload);
            mtContext.setTenantId(context.getTenant());
            mtContext.setSaasRegistryCallbackUrl(callbackUrl);
            mtContext.setInstanceCreationOptions(ico);
            this.service.emit(mtContext);
            context.getOptions().put(PARAM_APPLICATION_URL, mtContext.get(PARAM_APPLICATION_URL));
        }
    }

    @On(service={"MtSubscriptionService$Default"})
    @HandlerOrder(value=11000)
    protected void onUnsubscribe(MtUnsubscribeEventContext context) {
        try {
            if (context.getDelete() != null && context.getDelete().booleanValue()) {
                logger.info("Deleting subscription of tenant '{}'", (Object)context.getTenantId());
                this.subscriber.unsubscribe(context.getTenantId(), context.getDeletePayload(), this.forwardToken(context));
            } else {
                logger.info("Skipping subscription deletion of tenant '{}'", (Object)context.getTenantId());
            }
            context.setCompleted();
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUBSCRIPTION_FAILED, new Object[]{context.getTenantId(), e});
        }
        catch (ParameterError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[]{e});
        }
        catch (AuthorityError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[]{e});
        }
    }

    @On(service={"MtSubscriptionService$Default"})
    @HandlerOrder(value=11000)
    protected void onUnsubscribeAsync(MtAsyncUnsubscribeEventContext context) {
        SidecarUnSubscribeCallBackPayload payload = new SidecarUnSubscribeCallBackPayload();
        payload.tenantId = context.getTenantId();
        payload.saasRequestPayload = new SidecarUnSubscriptionPayload(context.getDeletePayload());
        payload.saasCallbackUrl = context.getSaasRegistryCallbackUrl();
        try {
            MtUnsubscribeEventContext syncContext = MtUnsubscribeEventContext.create();
            syncContext.setTenantId(context.getTenantId());
            syncContext.setDeletePayload(context.getDeletePayload());
            syncContext.setDelete(context.getDelete() != null ? context.getDelete() : false);
            this.onUnsubscribe(syncContext);
            payload.status = SUCCEEDED;
            payload.message = "Removing subscription succeeded";
            context.setCompleted();
        }
        catch (Exception e) {
            payload.status = FAILED;
            payload.message = "Removing subscription failed";
            throw e;
        }
        finally {
            this.service.finishAsyncUnsubscribe(payload);
        }
    }

    @On(service={"MtSubscriptionService$Default"})
    @HandlerOrder(value=11000)
    protected void onUnsubscribeAsyncFinished(MtAsyncUnsubscribeFinishedEventContext context) {
        context.setCompleted();
    }

    @Override
    protected void onUnsubscribe(UnsubscribeEventContext context) {
        DeletePayload payload = (DeletePayload)mapper.convertValue((Object)context.getOptions(), DeletePayload.class);
        String callbackUrl = context.getParameterInfo().getHeader("STATUS_CALLBACK");
        if (StringUtils.isEmpty((String)callbackUrl)) {
            MtUnsubscribeEventContext mtContext = MtUnsubscribeEventContext.create();
            mtContext.setDeletePayload(payload);
            mtContext.setTenantId(context.getTenant());
            this.service.emit(mtContext);
        } else {
            MtAsyncUnsubscribeEventContext mtContext = MtAsyncUnsubscribeEventContext.create();
            mtContext.setDeletePayload(payload);
            mtContext.setTenantId(context.getTenant());
            mtContext.setSaasRegistryCallbackUrl(callbackUrl);
            this.service.emit(mtContext);
        }
    }

    @On(service={"MtSubscriptionService$Default"})
    @HandlerOrder(value=11000)
    protected void onDeploy(MtDeployEventContext mtContext) {
        UpgradeEventContext context = UpgradeEventContext.create();
        context.setTenants(Arrays.asList(mtContext.getUpgradePayload().tenants));
        super.onUpgrade(context);
        mtContext.setCompleted();
    }

    @On(service={"MtSubscriptionService$Default"})
    @HandlerOrder(value=11000)
    protected void onDeployAsync(MtAsyncDeployEventContext context) {
        if (Boolean.TRUE.equals(context.get(PARAM_UPGRADE_COMPATIBILITY))) {
            MtDeployEventContext mtContext = MtDeployEventContext.create();
            mtContext.setUpgradePayload(context.getUpgradePayload());
            this.onDeploy(mtContext);
            context.setResult("DEPRECATED");
        } else {
            try {
                context.setResult(this.subscriber.setupDbTablesAsync(Arrays.asList(context.getUpgradePayload().tenants)));
            }
            catch (InternalError e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.DEPLOYMENT_FAILED, new Object[]{String.join((CharSequence)", ", context.getUpgradePayload().tenants), e});
            }
            catch (ParameterError e) {
                throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[]{e});
            }
            catch (AuthorityError e) {
                throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[]{e});
            }
        }
    }

    @On(service={"MtSubscriptionService$Default"})
    @HandlerOrder(value=11000)
    protected void onDeployAsyncStatus(MtAsyncDeployStatusEventContext context) {
        try {
            context.setResult(this.subscriber.updateStatus(context.getJobId()));
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.JOB_STATUS_UPDATE_FAILED, new Object[]{context.getJobId(), e});
        }
        catch (ParameterError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[]{e});
        }
        catch (AuthorityError e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[]{e});
        }
        catch (NotSupported e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[]{e});
        }
        catch (NotFound e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.JOB_NOT_FOUND, new Object[]{context.getJobId(), e});
        }
    }

    @Override
    protected void onUpgrade(UpgradeEventContext context) {
        SidecarUpgradePayload payload = new SidecarUpgradePayload();
        payload.tenants = context.getTenants().toArray(new String[0]);
        if (this.subscriber instanceof SubscriberImpl) {
            this.service.deploy(payload);
        } else {
            MtAsyncDeployEventContext mtContext = MtAsyncDeployEventContext.create();
            mtContext.setUpgradePayload(payload);
            mtContext.put(PARAM_UPGRADE_COMPATIBILITY, true);
            this.service.emit(mtContext);
        }
    }
}

