/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.Objects;
import com.sap.cds.integration.cloudsdk.rest.client.JsonRestClient;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.environment.ServiceBindingUtils;
import com.sap.cloud.environment.servicebinding.api.DefaultServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaasClient
extends JsonRestClient {
    private static final Logger logger = LoggerFactory.getLogger(SaasClient.class);
    private static final String TENANT_STATE = "state";
    private static final String SAAS_REGISTRY = "saas-registry";
    private static final String SAAS_MANAGER_BASE = "/saas-manager/v1/";
    private static final String APPLICATION_TENANTS_PATH = "/saas-manager/v1/application/subscriptions";
    private static final String SERVICE_TENANTS_PATH = "/saas-manager/v1/service/subscriptions?includeIndirectSubscriptions=true";
    private final String urlPath;

    public static Optional<ServiceBinding> findBinding(CdsRuntime runtime) {
        return runtime.getEnvironment().getServiceBindings().filter(b -> ServiceBindingUtils.matches((ServiceBinding)b, null, (String)SAAS_REGISTRY)).findFirst();
    }

    public SaasClient(ServiceBinding binding) {
        super(SaasClient.getSaasUrl(binding), SaasClient.checkBinding(binding), OnBehalfOf.TECHNICAL_USER_PROVIDER);
        this.urlPath = "service".equals(binding.getServicePlan().orElse(null)) ? SERVICE_TENANTS_PATH : APPLICATION_TENANTS_PATH;
    }

    public List<Map<String, Object>> getSubscribedTenants() throws IOException {
        logger.debug("Retrieving all tenants metadata from the SaaS registry");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ArrayNode resp = (ArrayNode)this.getRequest(this.urlPath).get("subscriptions");
        resp.forEach(tenant -> {
            String state;
            String string = state = tenant.get(TENANT_STATE) != null ? tenant.get(TENANT_STATE).asText() : null;
            if (Objects.equal((Object)state, (Object)"SUBSCRIBED") || Objects.equal((Object)state, (Object)"UPDATE_FAILED")) {
                result.add((Map)this.mapper.convertValue(tenant, (TypeReference)new TypeReference<Map<String, Object>>(){}));
            }
        });
        return result;
    }

    private static String getSaasUrl(ServiceBinding binding) {
        return binding.getCredentials().get("saas_registry_url").toString();
    }

    private static ServiceBinding checkBinding(ServiceBinding binding) {
        if (binding.getCredentials().get("uaa") == null) {
            HashMap<String, Map> credentials = new HashMap<String, Map>();
            binding.getCredentials().forEach(credentials::put);
            credentials.put("uaa", binding.getCredentials());
            return DefaultServiceBinding.builder().copy(Collections.emptyMap()).withName((String)binding.getName().orElse(null)).withCredentials(credentials).withServiceName((String)binding.getServiceName().orElse(null)).withServicePlan((String)binding.getServicePlan().orElse(null)).withTags((Iterable)binding.getTags()).build();
        }
        return binding;
    }
}

