/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.mt.impl;

import com.sap.cds.Struct;
import com.sap.cds.feature.mt.SaasClient;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.mt.ReadProviderTenantEventContext;
import com.sap.cds.services.mt.ReadTenantsEventContext;
import com.sap.cds.services.mt.TenantInfo;
import com.sap.cds.services.mt.TenantProviderService;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;

@ServiceName(value={"TenantProviderService$Default"}, type={TenantProviderService.class})
public class MtTenantProviderSaasHandler
implements EventHandler {
    private static final String KEY_TENANT_ID = "consumerTenantId";
    private static final String KEY_PROVIDER_TENANT_ID = "tenantid";
    private final SaasClient saasClient;
    private final String providerTenant;

    public MtTenantProviderSaasHandler(ServiceBinding binding) {
        this.saasClient = new SaasClient(binding);
        this.providerTenant = (String)binding.getCredentials().get(KEY_PROVIDER_TENANT_ID);
    }

    @On
    @HandlerOrder(value=10900)
    public void readTenants(ReadTenantsEventContext context) {
        try {
            context.setResult(this.saasClient.getSubscribedTenants().stream().map(this::toTenantInfo).collect(Collectors.toList()));
        }
        catch (IOException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.TENANT_READ_FAILED, new Object[]{e});
        }
    }

    @On
    @HandlerOrder(value=10900)
    public void readProviderTenant(ReadProviderTenantEventContext context) {
        if (this.providerTenant != null) {
            context.setResult(this.providerTenant);
        }
    }

    private TenantInfo toTenantInfo(Map<String, Object> tenant) {
        TenantInfo info = (TenantInfo)Struct.access(tenant).as(TenantInfo.class);
        info.setTenant(info.get((Object)KEY_TENANT_ID).toString());
        return info;
    }
}

