/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.mt;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;
import com.sap.xsa.core.instancemanager.client.InstanceCreationOptions;

/**
 * The {@link EventContext} used for the {@link MtSubscriptionService#EVENT_ASYNC_SUBSCRIBE} event.
 *
 * @deprecated Use {@link DeploymentService#subscribe(String, java.util.Map)} and {@link SubscribeEventContext} instead.
 */
@Deprecated
@EventName(MtSubscriptionService.EVENT_ASYNC_SUBSCRIBE)
public interface MtAsyncSubscribeEventContext extends EventContext {

	/**
	 * Creates an {@link EventContext} already overlayed with this interface. The event is set to be
	 * {@link MtSubscriptionService#EVENT_ASYNC_SUBSCRIBE}
	 * @return the {@link MtAsyncSubscribeEventContext}
	 */
	static MtAsyncSubscribeEventContext create() {
		return EventContext.create(MtAsyncSubscribeEventContext.class, null);
	}

	@Override
	MtSubscriptionService getService();

	/**
	 * @return the payload to subscribe the tenant
	 */
	SubscriptionPayload getSubscriptionPayload();

	/**
	 * @param payload the information to subscribe the tenant
	 */
	void setSubscriptionPayload(SubscriptionPayload payload);

	/**
	 * @return the tenant ID to subscribe
	 */
	String getTenantId();

	/**
	 * @param tenantId the tenant ID to subscribe
	 */
	void setTenantId(String tenantId);

	/**
	 * @return the callback URL of the SaaS Registry
	 */
	String getSaasRegistryCallbackUrl();

	/**
	 * @param url the callback URL of the SaaS Registry
	 */
	void setSaasRegistryCallbackUrl(String url);

	/**
	 * @return the callback URL of the SaaS Registry
	 */
	String getResult();

	/**
	 * @param url the callback URL of the SaaS Registry
	 */
	void setResult(String url);

	/**
	 * @return the options when creating a new Database instance
	 */
	InstanceCreationOptions getInstanceCreationOptions();

	/**
	 * @param options the options when creating a new Database instance
	 */
	void setInstanceCreationOptions(InstanceCreationOptions options);

}
