/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.mt;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import com.sap.cloud.mt.subscription.json.SidecarSubscribeCallBackPayload;

/**
 * The {@link EventContext} used for the {@link MtSubscriptionService#EVENT_ASYNC_SUBSCRIBE_FINISHED} event.
 *
 * @deprecated Use {@link DeploymentService#subscribe(String, java.util.Map)} and {@link SubscribeEventContext} instead.
 */
@Deprecated
@EventName(MtSubscriptionService.EVENT_ASYNC_SUBSCRIBE_FINISHED)
public interface MtAsyncSubscribeFinishedEventContext extends EventContext {

	/**
	 * Creates an {@link EventContext} already overlayed with this interface. The event is set to be
	 * {@link MtSubscriptionService#EVENT_ASYNC_SUBSCRIBE_FINISHED}
	 * @return the {@link MtAsyncSubscribeFinishedEventContext}
	 */
	static MtAsyncSubscribeFinishedEventContext create() {
		return EventContext.create(MtAsyncSubscribeFinishedEventContext.class, null);
	}

	@Override
	MtSubscriptionService getService();

	/**
	 * @return The payload contains information if the sidecar subscribed the tenant
	 */
	SidecarSubscribeCallBackPayload getCallbackPayload();

	/**
	 *
	 * @param payload contains information if the sidecar subscribed the tenant
	 */
	void setCallbackPayload(SidecarSubscribeCallBackPayload payload);

}
