/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.mt;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import com.sap.cloud.mt.subscription.json.SidecarUnSubscribeCallBackPayload;

/**
 * The {@link EventContext} used for the {@link MtSubscriptionService#EVENT_ASYNC_UNSUBSCRIBE_FINISHED} event.
 *
 * @deprecated Use {@link DeploymentService#unsubscribe(String, java.util.Map)} and {@link UnsubscribeEventContext} instead.
 */
@Deprecated
@EventName(MtSubscriptionService.EVENT_ASYNC_UNSUBSCRIBE_FINISHED)
public interface MtAsyncUnsubscribeFinishedEventContext extends EventContext {

	/**
	 * Creates an {@link EventContext} already overlayed with this interface. The event is set to be
	 * {@link MtSubscriptionService#EVENT_ASYNC_UNSUBSCRIBE_FINISHED}
	 * @return the {@link MtAsyncUnsubscribeFinishedEventContext}
	 */
	static MtAsyncUnsubscribeFinishedEventContext create() {
		return EventContext.create(MtAsyncUnsubscribeFinishedEventContext.class, null);
	}

	@Override
	MtSubscriptionService getService();

	/**
	 * @return The payload contains information if the sidecar unsubscribed the tenant
	 */
	SidecarUnSubscribeCallBackPayload getCallbackPayload();

	/**
	 * @param payload contains information if the sidecar unsubscribed the tenant
	 */
	void setCallbackPayload(SidecarUnSubscribeCallBackPayload payload);

}
