/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.mt;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import com.sap.cloud.mt.subscription.json.SidecarUpgradePayload;

/**
 * The {@link EventContext} used for the {@link MtSubscriptionService#EVENT_DEPLOY} event.
 *
 * @deprecated Use {@link DeploymentService#upgrade(java.util.List, java.util.Map)} and {@link UpgradeEventContext} instead.
 */
@Deprecated
@EventName(MtSubscriptionService.EVENT_DEPLOY)
public interface MtDeployEventContext extends EventContext {

	/**
	 * Creates an {@link EventContext} already overlayed with this interface. The event is set to be
	 * {@link MtSubscriptionService#EVENT_DEPLOY}
	 * @return the {@link MtDeployEventContext}
	 */
	static MtDeployEventContext create() {
		return EventContext.create(MtDeployEventContext.class, null);
	}

	@Override
	MtSubscriptionService getService();

	/**
	 * @return the payload to trigger updating individual tenants by specifying tenants individually or "all" to update all tenants
	 */
	SidecarUpgradePayload getUpgradePayload();

	/**
	 * @param payload the payload to trigger updating individual tenants by specifying tenants individually or "all" to update all tenants
	 */
	void setUpgradePayload(SidecarUpgradePayload payload);

}
