/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.mt;

import java.util.List;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import com.sap.cloud.mt.subscription.json.ApplicationDependency;

/**
 * The {@link EventContext} used for the {@link MtSubscriptionService#EVENT_GET_DEPENDENCIES} event.
 *
 * @deprecated Use {@link DeploymentService#dependencies()} and {@link DependenciesEventContext} instead.
 */
@Deprecated
@EventName(MtSubscriptionService.EVENT_GET_DEPENDENCIES)
public interface MtGetDependenciesEventContext extends EventContext {

	/**
	 * Creates an {@link EventContext} already overlayed with this interface. The event is set to be
	 * {@link MtSubscriptionService#EVENT_GET_DEPENDENCIES}
	 * @return the {@link MtGetDependenciesEventContext}
	 */
	static MtGetDependenciesEventContext create() {
		return EventContext.create(MtGetDependenciesEventContext.class, null);
	}

	@Override
	MtSubscriptionService getService();

	/**
	 * @return the list of application dependencies
	 */
	List<ApplicationDependency> getResult();

	/**
	 * @param dependencies the list of application dependencies
	 */
	void setResult(List<ApplicationDependency> dependencies);

}
