/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.mt;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import com.sap.cloud.mt.subscription.json.DeletePayload;

/**
 * The {@link EventContext} used for the {@link MtSubscriptionService#EVENT_UNSUBSCRIBE} event.
 *
 * @deprecated Use {@link DeploymentService#unsubscribe(String, java.util.Map)} and {@link UnsubscribeEventContext} instead.
 */
@Deprecated
@EventName(MtSubscriptionService.EVENT_UNSUBSCRIBE)
public interface MtUnsubscribeEventContext extends EventContext {

	/**
	 * Creates an {@link EventContext} already overlayed with this interface. The event is set to be
	 * {@link MtSubscriptionService#EVENT_UNSUBSCRIBE}
	 * @return the {@link MtUnsubscribeEventContext}
	 */
	static MtUnsubscribeEventContext create() {
		return EventContext.create(MtUnsubscribeEventContext.class, null);
	}

	@Override
	MtSubscriptionService getService();

	/**
	 * @return the payload to delete the tenant
	 */
	DeletePayload getDeletePayload();

	/**
	 * @param payload the information to delete the tenant
	 */
	void setDeletePayload(DeletePayload payload);

	/**
	 * @return the tenant ID to unsubscribe
	 */
	String getTenantId();

	/**
	 * @param tenantId the tenant ID to unsubscribe
	 */
	void setTenantId(String tenantId);

	/**
	 * @return true, if the tenant is to be deleted, false, if the tenant is to be skipped
	 */
	Boolean getDelete();

	/**
	 * @param delete true, if the tenant is to be deleted, false, if the tenant is to be skipped
	 */
	void setDelete(boolean delete);

}
