/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.mt;

import java.util.Map;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;

public interface SmsUserInfo extends CdsData {

	static SmsUserInfo create() {
		return Struct.create(SmsUserInfo.class);
	}

	static SmsUserInfo create(Map<String, Object> attributes) {
		return Struct.access(attributes).as(SmsUserInfo.class);
	}

	String getUserId();

	void setUserId(String userId);

	String getUserGuid();

	void setUserGuid(String userGuid);

	String getUserName();

	void setUserName(String userName);

	String getEmail();

	void setEmail(String email);

	String getSubIdp();

	void setSubIdp(String idp);

	String getSub();

	void setSub(String sub);
}
