/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.mt.impl;

import java.util.List;

import com.sap.cds.services.ServiceDelegator;
import com.sap.cds.services.mt.MtAsyncDeployEventContext;
import com.sap.cds.services.mt.MtAsyncDeployStatusEventContext;
import com.sap.cds.services.mt.MtAsyncSubscribeEventContext;
import com.sap.cds.services.mt.MtAsyncSubscribeFinishedEventContext;
import com.sap.cds.services.mt.MtAsyncUnsubscribeEventContext;
import com.sap.cds.services.mt.MtAsyncUnsubscribeFinishedEventContext;
import com.sap.cds.services.mt.MtDeployEventContext;
import com.sap.cds.services.mt.MtGetDependenciesEventContext;
import com.sap.cds.services.mt.MtSubscribeEventContext;
import com.sap.cds.services.mt.MtSubscriptionService;
import com.sap.cds.services.mt.MtUnsubscribeEventContext;
import com.sap.cloud.mt.subscription.json.ApplicationDependency;
import com.sap.cloud.mt.subscription.json.DeletePayload;
import com.sap.cloud.mt.subscription.json.SidecarSubscribeCallBackPayload;
import com.sap.cloud.mt.subscription.json.SidecarUnSubscribeCallBackPayload;
import com.sap.cloud.mt.subscription.json.SidecarUpgradePayload;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;

@SuppressWarnings({"deprecation", "removal"})
public class MtSubscriptionServiceImpl extends ServiceDelegator implements MtSubscriptionService {

	public MtSubscriptionServiceImpl(String name) {
		super(name);
	}

	@Override
	public List<ApplicationDependency> getDependencies() {
		MtGetDependenciesEventContext context = MtGetDependenciesEventContext.create();
		emit(context);
		return context.getResult();
	}

	@Override
	public String subscribe(SubscriptionPayload payload, String tenantId) {
		MtSubscribeEventContext context = MtSubscribeEventContext.create();
		context.setSubscriptionPayload(payload);
		context.setTenantId(tenantId);
		emit(context);
		return context.getResult();
	}

	@Override
	public void unsubscribe(DeletePayload payload, String tenantId) {
		MtUnsubscribeEventContext context = MtUnsubscribeEventContext.create();
		context.setDeletePayload(payload);
		context.setTenantId(tenantId);
		emit(context);
	}

	@Override
	public void deploy(SidecarUpgradePayload payload) {
		MtDeployEventContext context = MtDeployEventContext.create();
		context.setUpgradePayload(payload);
		emit(context);
	}

	@Override
	public String asyncDeploy(SidecarUpgradePayload payload) {
		return asyncDeploy(payload, null);
	}

	@Override
	public String asyncDeployStatus(String jobId) {
		return asyncDeployStatus(jobId, null);
	}

	@Override
	public String asyncDeploy(SidecarUpgradePayload payload, String authorizationHeader) {
		MtAsyncDeployEventContext context = MtAsyncDeployEventContext.create();
		context.setUpgradePayload(payload);
		context.setAuthorizationHeader(authorizationHeader);
		emit(context);
		return context.getResult();
	}

	@Override
	public String asyncDeployStatus(String jobId, String authorizationHeader) {
		MtAsyncDeployStatusEventContext context = MtAsyncDeployStatusEventContext.create();
		context.setJobId(jobId);
		context.setAuthorizationHeader(authorizationHeader);
		emit(context);
		return context.getResult();
	}

	@Override
	public String asyncSubscribe(SubscriptionPayload payload, String tenantId, String callbackUrl) {
		MtAsyncSubscribeEventContext context = MtAsyncSubscribeEventContext.create();
		context.setSubscriptionPayload(payload);
		context.setTenantId(tenantId);
		context.setSaasRegistryCallbackUrl(callbackUrl);
		emit(context);
		return context.getResult();
	}

	@Override
	public void asyncUnsubscribe(DeletePayload payload, String tenantId, String callbackUrl) {
		MtAsyncUnsubscribeEventContext context = MtAsyncUnsubscribeEventContext.create();
		context.setDeletePayload(payload);
		context.setTenantId(tenantId);
		context.setSaasRegistryCallbackUrl(callbackUrl);
		emit(context);
	}

	@Override
	public void finishAsyncSubscribe(SidecarSubscribeCallBackPayload payload) {
		MtAsyncSubscribeFinishedEventContext context = MtAsyncSubscribeFinishedEventContext.create();
		context.setCallbackPayload(payload);
		emit(context);
	}

	@Override
	public void finishAsyncUnsubscribe(SidecarUnSubscribeCallBackPayload payload) {
		MtAsyncUnsubscribeFinishedEventContext context = MtAsyncUnsubscribeFinishedEventContext.create();
		context.setCallbackPayload(payload);
		emit(context);
	}
}
