/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.mt.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.mt.DeploymentService;
import com.sap.cds.services.mt.UnsubscribeEventContext;
import com.sap.cloud.mt.runtime.TenantAwareDataSource;

/**
 * AFTER handler for mt unsubscription events.
 */
@ServiceName(DeploymentService.DEFAULT_NAME)
public class MtUnsubscriptionClearDatasourceHandler implements EventHandler {

	private static final Logger log = LoggerFactory.getLogger(MtUnsubscriptionClearDatasourceHandler.class);

	private final TenantAwareDataSource dataSource;

	public MtUnsubscriptionClearDatasourceHandler(TenantAwareDataSource dataSource) {
		this.dataSource = dataSource;
	}

	@After
	protected void afterUnsubscribe(UnsubscribeEventContext context) {
		if (dataSource != null) {
			log.debug("Removing data source of tenant '{}' from cache", context.getTenant());
			dataSource.deleteFromCache(context.getTenant());
		}
	}

}
