/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.mt.impl;

import com.sap.cds.services.auditlog.AuditLogService;
import com.sap.cds.services.auditlog.event.TenantOffboardedEventContext;
import com.sap.cds.services.auditlog.event.TenantOnboardedEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.mt.DeploymentService;
import com.sap.cds.services.mt.SubscribeEventContext;
import com.sap.cds.services.mt.UnsubscribeEventContext;

/**
 * Implementation handler for audit logging of tenant on/off-boarding
 */
@ServiceName(DeploymentService.DEFAULT_NAME)
public class TenantSubscriptionAuditLogHandler implements EventHandler {

	private final AuditLogService auditLog;

	public TenantSubscriptionAuditLogHandler(AuditLogService auditLog) {
		this.auditLog = auditLog;
	}

	@After
	public void afterSubscribe(SubscribeEventContext context) {
		TenantOnboardedEventContext ctx = TenantOnboardedEventContext.create();
		ctx.put("tenant", context.getTenant());
		auditLog.emit(ctx);
	}

	@After
	public void afterUnsubscribe(UnsubscribeEventContext context) {
		TenantOffboardedEventContext ctx = TenantOffboardedEventContext.create();
		ctx.put("tenant", context.getTenant());
		auditLog.emit(ctx);
	}

}
