/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.sms;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

class CertValidator {
    private static final String CERTIFICATE_HEADER = "-----BEGIN CERTIFICATE-----";
    private static final String CALLBACK_CERTIFICATE_ISSUER = "callback_certificate_issuer";
    private static final String CALLBACK_CERTIFICATE_SUBJECT = "callback_certificate_subject";
    private static final String X_509 = "X.509";
    private final ObjectMapper mapper = new ObjectMapper();
    private final CertificateFactory certFactory = CertValidator.getX509CertFactory();
    private final Map<String, Object> expectedIssuer;
    private final Map<String, Object> expectedSubject;
    private final String clientCertificateHeaderName;

    CertValidator(String clientCertificateHeaderName, String expectedIssuer, String expectedSubject) {
        this.clientCertificateHeaderName = clientCertificateHeaderName;
        try {
            this.expectedIssuer = this.jsonStrToFlatMap(expectedIssuer);
            this.expectedSubject = this.jsonStrToFlatMap(expectedSubject);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static CertValidator create(CdsRuntime runtime, ServiceBinding smsBinding) {
        String clientCertificateHeaderName = runtime.getEnvironment().getCdsProperties().getMultiTenancy().getSubscriptionManager().getClientCertificateHeader();
        String expecedIssuer = (String)smsBinding.getCredentials().get(CALLBACK_CERTIFICATE_ISSUER);
        String expectedSubject = (String)smsBinding.getCredentials().get(CALLBACK_CERTIFICATE_SUBJECT);
        return new CertValidator(clientCertificateHeaderName, expecedIssuer, expectedSubject);
    }

    private static CertificateFactory getX509CertFactory() {
        try {
            return CertificateFactory.getInstance(X_509);
        }
        catch (CertificateException e) {
            return null;
        }
    }

    @VisibleForTesting
    X509Certificate getX509Certificate(String cert) throws Exception {
        ByteArrayInputStream is = cert.startsWith(CERTIFICATE_HEADER) ? new ByteArrayInputStream(cert.getBytes(StandardCharsets.UTF_8)) : new ByteArrayInputStream(Base64.getDecoder().decode(cert));
        return (X509Certificate)this.certFactory.generateCertificate(is);
    }

    void validateCertFromRequestContext(RequestContext requestContext) {
        String cert = requestContext.getParameterInfo().getHeader(this.clientCertificateHeaderName);
        if (cert != null) {
            X509Certificate certificate;
            try {
                certificate = this.getX509Certificate(cert);
            }
            catch (Exception e) {
                throw new ErrorStatusException((ErrorStatus)ErrorStatuses.UNAUTHORIZED, new Object[0]);
            }
            if (!this.isValidCertIssuer(certificate.getIssuerX500Principal().toString()) || !this.isValidCertSubject(certificate.getSubjectX500Principal().toString())) {
                throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[0]);
            }
        } else {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.UNAUTHORIZED, new Object[0]);
        }
    }

    @VisibleForTesting
    boolean isValidCertSubject(String subjectFromCert) {
        boolean valid;
        boolean bl = valid = subjectFromCert.contains("C=" + this.expectedSubject.get("C")) && subjectFromCert.contains("CN=" + this.expectedSubject.get("CN")) && ("*".equals(this.expectedSubject.get("L")) || subjectFromCert.contains("L=" + this.expectedSubject.get("L"))) && subjectFromCert.contains("O=" + this.expectedSubject.get("O"));
        if (this.expectedSubject.get("OU").toString().startsWith("[") && this.expectedSubject.get("OU").toString().endsWith("]")) {
            ArrayList items = (ArrayList)this.expectedSubject.get("OU");
            for (String item : items) {
                valid = valid && subjectFromCert.contains("OU=" + item);
            }
        } else {
            valid = valid && subjectFromCert.contains("OU=" + this.expectedSubject.get("OU"));
        }
        return valid;
    }

    @VisibleForTesting
    boolean isValidCertIssuer(String issuerFromCert) {
        return issuerFromCert.contains("C=" + this.expectedIssuer.get("C")) && issuerFromCert.contains("OU=" + this.expectedIssuer.get("OU")) && issuerFromCert.contains("CN=" + this.expectedIssuer.get("CN")) && ("*".equals(this.expectedIssuer.get("L")) || issuerFromCert.contains("L=" + this.expectedIssuer.get("L"))) && issuerFromCert.contains("O=" + this.expectedIssuer.get("O"));
    }

    @VisibleForTesting
    Map<String, Object> jsonStrToFlatMap(String json) throws IOException {
        return (Map)this.mapper.readValue(json, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
    }
}

