/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.mt.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.mt.subscription.Subscriber;
import com.sap.cloud.mt.subscription.exceptions.AuthorityError;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.subscription.exceptions.NotFound;
import com.sap.cloud.mt.subscription.exceptions.NotSupported;
import com.sap.cloud.mt.subscription.exceptions.ParameterError;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSidecarUpgradeHelper {
    private static final Logger logger = LoggerFactory.getLogger(AsyncSidecarUpgradeHelper.class);
    private static final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final String SIDECAR_STATUS_RUNNING = "RUNNING";
    private static final String SIDECAR_STATUS_FAILED = "FAILED";
    private static final Set<String> SIDECAR_SUCCESS_STATUSES = new HashSet<String>(Arrays.asList("SUCCESS", "NON-EXISTENT"));
    private final Subscriber subscriber;

    public AsyncSidecarUpgradeHelper(Subscriber subscriber) {
        this.subscriber = subscriber;
    }

    public void deploy(List<String> tenants) throws AuthorityError, ParameterError, InternalError, NotSupported, NotFound {
        try {
            boolean failed;
            String statusJson;
            SidecarResult sidecarResult;
            String jobIdJson = this.subscriber.setupDbTablesAsync(tenants);
            String jobId = ((JobIdResult)AsyncSidecarUpgradeHelper.mapper.readValue((String)jobIdJson, JobIdResult.class)).jobID;
            do {
                Thread.sleep(2000L);
                statusJson = this.subscriber.updateStatus(jobId);
                sidecarResult = (SidecarResult)mapper.readValue(statusJson, SidecarResult.class);
            } while (SIDECAR_STATUS_RUNNING.equals(this.upper(sidecarResult.status)));
            boolean bl = failed = SIDECAR_STATUS_FAILED.equals(this.upper(sidecarResult.status)) || sidecarResult.error != null;
            if (!failed && sidecarResult.result != null && sidecarResult.result.tenants != null) {
                failed = sidecarResult.result.tenants.values().stream().anyMatch(tenant -> !SIDECAR_SUCCESS_STATUSES.contains(this.upper(tenant.status)));
            }
            if (!failed && sidecarResult.tenants != null) {
                failed = sidecarResult.tenants.values().stream().anyMatch(tenant -> SIDECAR_STATUS_FAILED.equals(this.upper(tenant.status)));
            }
            if (failed) {
                throw new InternalError("Updating failed with response '" + statusJson + "'");
            }
            logger.debug("Updating succeeded with response '{}'", (Object)statusJson);
        }
        catch (JsonProcessingException e) {
            throw new InternalError("Failed to parse sidecar response", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private String upper(String s) {
        return s == null ? s : s.toUpperCase(Locale.ENGLISH);
    }

    private static final class JobIdResult {
        public String jobID;

        private JobIdResult() {
        }
    }

    private static final class SidecarResult {
        public String status;
        public String error;
        public DeployResult result;
        public Map<String, DeployResult.TenantResult> tenants;

        private SidecarResult() {
        }

        private static final class DeployResult {
            public Map<String, TenantResult> tenants;

            private DeployResult() {
            }

            private static final class TenantResult {
                public String status;

                private TenantResult() {
                }
            }
        }
    }
}

