/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.mt.impl;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.Struct;
import com.sap.cds.feature.mt.SaasClient;
import com.sap.cds.feature.mt.SmsClient;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.mt.ReadProviderTenantEventContext;
import com.sap.cds.services.mt.ReadTenantsEventContext;
import com.sap.cds.services.mt.TenantInfo;
import com.sap.cds.services.mt.TenantProviderService;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@ServiceName(value={"TenantProviderService$Default"}, type={TenantProviderService.class})
public class MtTenantProviderSaasOrSmsHandler
implements EventHandler {
    private static final String KEY_TENANT_ID = "consumerTenantId";
    private static final String KEY_PROVIDER_TENANT_ID = "tenantid";
    public static final String SAAS = "saasRegistry";
    public static final String SUBSCRIBER = "subscriber";
    public static final String ZONE_ID = "zoneId";
    public static final String APP_TID = "app_tid";
    private final SaasClient saasClient;
    private final SmsClient smsClient;
    private final String providerTenant;

    @VisibleForTesting
    MtTenantProviderSaasOrSmsHandler(SaasClient saasClient, SmsClient smsClient, String providerTenant) {
        this.saasClient = saasClient;
        this.smsClient = smsClient;
        this.providerTenant = providerTenant;
    }

    public static MtTenantProviderSaasOrSmsHandler create(ServiceBinding saasBinding, ServiceBinding smsBinding) {
        SaasClient saasClient = saasBinding != null ? new SaasClient(saasBinding) : null;
        SmsClient smsClient = smsBinding != null ? new SmsClient(smsBinding) : null;
        String providerTenant = null;
        if (saasBinding != null) {
            providerTenant = (String)saasBinding.getCredentials().get(KEY_PROVIDER_TENANT_ID);
        } else if (smsBinding != null) {
            providerTenant = (String)smsBinding.getCredentials().get(KEY_PROVIDER_TENANT_ID);
        }
        return new MtTenantProviderSaasOrSmsHandler(saasClient, smsClient, providerTenant);
    }

    @On
    @HandlerOrder(value=10900)
    public void readTenants(ReadTenantsEventContext context) {
        try {
            HashMap tenantInfoByTenantFromSaas = new HashMap();
            if (this.saasClient != null) {
                this.saasClient.getSubscribedTenants().stream().map(this::toSaasTenantInfo).forEach(t -> tenantInfoByTenantFromSaas.put(t.getTenant(), t));
            }
            ArrayList tenants = new ArrayList();
            if (this.smsClient != null) {
                this.smsClient.getSubscribedTenants().stream().map(this::toSmsTenantInfo).forEach(t -> {
                    TenantInfo tenantInfoFromSaas = (TenantInfo)tenantInfoByTenantFromSaas.remove(t.getTenant());
                    if (tenantInfoFromSaas != null) {
                        t.put((Object)SAAS, (Object)tenantInfoFromSaas);
                    }
                    tenants.add(t);
                });
            }
            tenants.addAll(tenantInfoByTenantFromSaas.values());
            context.setResult(tenants);
        }
        catch (Exception e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.TENANT_READ_FAILED, new Object[]{e});
        }
    }

    @On
    @HandlerOrder(value=10900)
    public void readProviderTenant(ReadProviderTenantEventContext context) {
        if (this.providerTenant != null) {
            context.setResult(this.providerTenant);
        }
    }

    private TenantInfo toSaasTenantInfo(Map<String, Object> tenant) {
        TenantInfo info = (TenantInfo)Struct.access(tenant).as(TenantInfo.class);
        info.setTenant(info.get((Object)KEY_TENANT_ID).toString());
        return info;
    }

    private TenantInfo toSmsTenantInfo(Map<String, Object> tenant) {
        TenantInfo info = (TenantInfo)Struct.access(tenant).as(TenantInfo.class);
        Object subscriber = info.get((Object)SUBSCRIBER);
        String tenantId = (String)((Map)subscriber).get(APP_TID);
        if (tenantId == null) {
            tenantId = (String)((Map)subscriber).get(ZONE_ID);
        }
        info.setTenant(tenantId);
        return info;
    }
}

