/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.environment.ServiceBindingUtils;
import com.sap.cds.services.utils.model.DynamicModelUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.mt.subscription.DbCredentials;
import com.sap.cloud.mt.subscription.DbCredentialsBuilder;
import com.sap.cloud.mt.subscription.DbIdentifiers;
import com.sap.cloud.mt.subscription.DbIdentifiersSqLite;
import com.sap.cloud.mt.subscription.DbIdentifiersSql;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.InstanceLifecycleManagerBuilder;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.xsa.core.instancemanager.client.ImClientException;
import com.sap.xsa.core.instancemanager.client.ServiceManagerClient;
import com.sap.xsa.core.instancemanager.client.impl.InstanceManagerClientFactory;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MtUtils {
    private static final String HANA_OFFERING_NAME = "hana";
    private static final String HANA_HDI_PLAN_NAME = "hdi-shared";
    static final String SERVICE_MANAGER = "service-manager";
    static final String MT_ENABLED = "mt-enabled";
    static final String SQLITE_BINDING_NAME = "mtx-sqlite";
    private final DynamicModelUtils dynamicModelUtils;
    private final CdsProperties.MultiTenancy config;
    private final List<ServiceBinding> bindings;
    private final ServiceBinding defaultBinding;

    public MtUtils(CdsRuntime runtime) {
        this.dynamicModelUtils = new DynamicModelUtils(runtime);
        this.config = runtime.getEnvironment().getCdsProperties().getMultiTenancy();
        this.bindings = runtime.getEnvironment().getServiceBindings().filter(b -> this.isServiceManagerBinding((ServiceBinding)b) || this.isSchemaBasedMtBinding((ServiceBinding)b)).collect(Collectors.toList());
        String bindingName = runtime.getEnvironment().getCdsProperties().getDataSource().getBinding();
        if (StringUtils.isEmpty((String)bindingName)) {
            if (this.bindings.size() == 1) {
                this.defaultBinding = this.bindings.get(0);
            } else {
                if (this.bindings.size() > 1) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_UNIQUE_DATASOURCE_SERVICE, new Object[0]);
                }
                this.defaultBinding = null;
            }
        } else {
            this.defaultBinding = this.bindings.stream().filter(b -> ((String)b.getName().get()).equals(bindingName)).findFirst().orElse(null);
        }
    }

    public boolean requiresSubscription() {
        boolean deployerConfigured = this.hasDeployer();
        return this.defaultBinding != null && (deployerConfigured || this.isSchemaBasedMtBinding(this.defaultBinding)) || this.isSqliteDataSourceEnabled() && deployerConfigured;
    }

    private boolean hasDeployer() {
        boolean sidecarOrProvisioningService;
        boolean dynamicDeployer = !StringUtils.isEmpty((String)this.config.getDeployer().getUrl());
        boolean bl = sidecarOrProvisioningService = this.isClassicSidecarEnabled() || this.isProvisioningServiceEnabled();
        if (dynamicDeployer && sidecarOrProvisioningService) {
            throw new IllegalArgumentException("Either Sidecar or Deployer URL can be specified");
        }
        return dynamicDeployer || sidecarOrProvisioningService;
    }

    public boolean isClassicSidecarEnabled() {
        return this.dynamicModelUtils.isClassicSidecarEnabled();
    }

    public boolean isProvisioningServiceEnabled() {
        return this.config.getMtxs().isEnabled() != false && !StringUtils.isEmpty((String)this.getProvisioningServiceUrl());
    }

    public String getProvisioningServiceUrl() {
        return !StringUtils.isEmpty((String)this.config.getProvisioning().getUrl()) ? this.config.getProvisioning().getUrl() : this.config.getSidecar().getUrl();
    }

    public InstanceLifecycleManager createDefaultInstanceLifecycleManager() {
        if (this.defaultBinding != null) {
            return this.createInstanceLifecycleManager(this.defaultBinding);
        }
        if (this.isSqliteDataSourceEnabled()) {
            return this.createInstanceLifecycleManagerSqlite();
        }
        return null;
    }

    public Map<String, InstanceLifecycleManager> createInstanceLifecycleManagers() {
        HashMap<String, InstanceLifecycleManager> ilms = new HashMap<String, InstanceLifecycleManager>();
        for (ServiceBinding binding : this.bindings) {
            ilms.put((String)binding.getName().get(), this.createInstanceLifecycleManager(binding));
        }
        if (this.isSqliteDataSourceEnabled()) {
            ilms.put(SQLITE_BINDING_NAME, this.createInstanceLifecycleManagerSqlite());
        }
        return ilms;
    }

    private boolean isSqliteDataSourceEnabled() {
        return this.bindings.isEmpty() && this.config.getMock().isEnabled() != false && this.isProvisioningServiceEnabled();
    }

    private boolean isServiceManagerBinding(ServiceBinding b) {
        return ServiceBindingUtils.matches((ServiceBinding)b, (String)SERVICE_MANAGER);
    }

    private boolean isSchemaBasedMtBinding(ServiceBinding b) {
        return ServiceBindingUtils.matches((ServiceBinding)b, (String)MT_ENABLED, null);
    }

    private InstanceLifecycleManager createInstanceLifecycleManagerSqlite() {
        InstanceLifecycleManagerBuilder builder = InstanceLifecycleManagerBuilder.create();
        String sqliteDirectory = this.config.getMock().getSqliteDirectory();
        if (!StringUtils.isEmpty((String)sqliteDirectory)) {
            builder.dbIdentifiers((DbIdentifiers)new DbIdentifiersSqLite(Paths.get(sqliteDirectory, new String[0])));
        } else {
            builder.dbIdentifiers((DbIdentifiers)new DbIdentifiersSqLite(Paths.get(System.getProperty("user.dir"), new String[0])));
        }
        try {
            return builder.build();
        }
        catch (InternalError internalError) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MT_LIB_SETUP_FAILED, new Object[]{internalError});
        }
    }

    private InstanceLifecycleManager createInstanceLifecycleManager(ServiceBinding binding) {
        InstanceLifecycleManager newIlm;
        InstanceLifecycleManagerBuilder builder = InstanceLifecycleManagerBuilder.create();
        if (this.isServiceManagerBinding(binding)) {
            builder.serviceManagerClient(this.getServiceManagerClient(binding));
            builder.timeout(this.config.getServiceManager().getTimeout());
            builder.smCacheRefreshInterval(this.config.getServiceManager().getCacheRefreshInterval());
            try {
                newIlm = builder.build();
            }
            catch (InternalError internalError) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INSTANCE_MANAGER_CLIENT_FAILED, new Object[]{binding.getName().get(), internalError});
            }
        }
        try {
            DbCredentials dbCredentials = DbCredentialsBuilder.create().credentials(binding.getCredentials()).build();
            builder.dbIdentifiers((DbIdentifiers)new DbIdentifiersSql(Collections.singletonList(dbCredentials)));
            newIlm = builder.build();
        }
        catch (InternalError internalError) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MT_LIB_SETUP_FAILED, new Object[]{internalError.getMessage(), internalError});
        }
        return newIlm;
    }

    @VisibleForTesting
    ServiceManagerClient getServiceManagerClient(ServiceBinding binding) {
        try {
            Map credentials = binding.getCredentials();
            if (!StringUtils.isEmpty((String)((String)credentials.get("clientsecret")))) {
                return InstanceManagerClientFactory.getInstance((String)((String)credentials.get("xsappname")), (String)((String)credentials.get("sm_url")), (String)((String)credentials.get("url")), (String)((String)credentials.get("clientid")), (String)((String)credentials.get("clientsecret")), (String)HANA_OFFERING_NAME, (String)HANA_HDI_PLAN_NAME);
            }
            if (!StringUtils.isEmpty((String)((String)credentials.get("certificate")))) {
                return InstanceManagerClientFactory.getInstance((String)((String)credentials.get("xsappname")), (String)((String)credentials.get("sm_url")), (String)((String)credentials.get("certurl")), (String)((String)credentials.get("clientid")), (String)((String)credentials.get("key")), (String)((String)credentials.get("certificate")), (String)HANA_OFFERING_NAME, (String)HANA_HDI_PLAN_NAME);
            }
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INSTANCE_MANAGER_CLIENT_FAILED, new Object[]{binding.getName().get()});
        }
        catch (ImClientException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INSTANCE_MANAGER_CLIENT_FAILED, new Object[]{binding.getName().get(), e});
        }
    }

    @VisibleForTesting
    ServiceBinding getDefaultBinding() {
        return this.defaultBinding;
    }
}

