/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.mt;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import com.sap.cloud.mt.subscription.json.SidecarUpgradePayload;

/**
 * The {@link EventContext} used for the {@link MtSubscriptionService#EVENT_ASYNC_DEPLOY} event.
 *
 * @deprecated Use {@link DeploymentService#upgrade(java.util.List, java.util.Map)} and {@link UpgradeEventContext} instead.
 */
@Deprecated
@EventName(MtSubscriptionService.EVENT_ASYNC_DEPLOY)
public interface MtAsyncDeployEventContext extends EventContext {

	/**
	 * Creates an {@link EventContext} already overlayed with this interface. The event is set to be
	 * {@link MtSubscriptionService#EVENT_ASYNC_DEPLOY}
	 * @return the {@link MtAsyncDeployEventContext}
	 */
	static MtAsyncDeployEventContext create() {
		return EventContext.create(MtAsyncDeployEventContext.class, null);
	}

	@Override
	MtSubscriptionService getService();

	/**
	 * @return the payload which triggers updating individual tenants by specifying tenants individually, or "all" to update all tenants
	 */
	SidecarUpgradePayload getUpgradePayload();

	/**
	 * @param payload the payload which triggers updating individual tenants by specifying tenants individually, or "all" to update all tenants
	 */
	void setUpgradePayload(SidecarUpgradePayload payload);

	/**
	 * @return the header containing the OAuth2 authorization token
	 */
	String getAuthorizationHeader();

	/**
	 * @param authorizationHeader the header containing the OAuth2 authorization token
	 */
	void setAuthorizationHeader(String authorizationHeader);

	/**
	 * @return JobId which is returned from the Sidecar
	 */
	String getResult();

	/**
	 * @param jobId which is returned from the Sidecar
	 */
	void setResult(String jobId);

}
