/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.mt;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

/**
 * The {@link EventContext} used for the {@link MtSubscriptionService#EVENT_ASYNC_DEPLOY_STATUS} event.
 *
 * @deprecated Use {@link DeploymentService#upgrade(java.util.List, java.util.Map)} and {@link UpgradeEventContext} instead.
 */
@Deprecated
@EventName(MtSubscriptionService.EVENT_ASYNC_DEPLOY_STATUS)
public interface MtAsyncDeployStatusEventContext extends EventContext {

	/**
	 * Creates an {@link EventContext} already overlayed with this interface. The event is set to be
	 * {@link MtSubscriptionService#EVENT_ASYNC_DEPLOY_STATUS}
	 * @return the {@link MtAsyncDeployStatusEventContext}
	 */
	static MtAsyncDeployStatusEventContext create() {
		return EventContext.create(MtAsyncDeployStatusEventContext.class, null);
	}

	@Override
	MtSubscriptionService getService();

	/**
	 * @return the jobId which is returned from the Sidecar
	 */
	String getJobId();

	/**
	 * @param jobId which is returned from the Sidecar
	 */
	void setJobId(String jobId);

	/**
	 * @return the header containing the OAuth2 authorization token
	 */
	String getAuthorizationHeader();

	/**
	 * @param authorizationHeader the header containing the OAuth2 authorization token
	 */
	void setAuthorizationHeader(String authorizationHeader);

	/**
	 * @return jobId which is returned from the Sidecar
	 */
	String getResult();

	/**
	 * @param jobId which is returned from the Sidecar
	 */
	void setResult(String jobId);

}
