/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.mt;

import java.util.List;

import com.sap.cds.services.Service;
import com.sap.cloud.mt.subscription.json.ApplicationDependency;
import com.sap.cloud.mt.subscription.json.DeletePayload;
import com.sap.cloud.mt.subscription.json.SidecarSubscribeCallBackPayload;
import com.sap.cloud.mt.subscription.json.SidecarUnSubscribeCallBackPayload;
import com.sap.cloud.mt.subscription.json.SidecarUpgradePayload;
import com.sap.cloud.mt.subscription.json.SubscriptionPayload;

/**
 * Service for the subscription events.
 * @deprecated Use {@link DeploymentService} instead.
 */
@Deprecated
public interface MtSubscriptionService extends Service {

	String DEFAULT_NAME = "MtSubscriptionService$Default";

	String EVENT_GET_DEPENDENCIES = "GET_DEPENDENCIES";
	String EVENT_SUBSCRIBE = "SUBSCRIBE";
	String EVENT_ASYNC_SUBSCRIBE = "ASYNC_SUBSCRIBE";
	String EVENT_ASYNC_SUBSCRIBE_FINISHED = "ASYNC_SUBSCRIBE_FINISHED";
	String EVENT_UNSUBSCRIBE = "UNSUBSCRIBE";
	String EVENT_ASYNC_UNSUBSCRIBE = "ASYNC_UNSUBSCRIBE";
	String EVENT_ASYNC_UNSUBSCRIBE_FINISHED = "ASYNC_UNSUBSCRIBE_FINISHED";
	String EVENT_DEPLOY = "DEPLOY";
	String EVENT_ASYNC_DEPLOY = "ASYNC_DEPLOY";
	String EVENT_ASYNC_DEPLOY_STATUS = "ASYNC_DEPLOY_STATUS";

	/**
	 * @deprecated Use {@link DeploymentService#dependencies()} instead.
	 */
	List<ApplicationDependency> getDependencies();

	/**
	 * @deprecated Use {@link DeploymentService#subscribe(String, java.util.Map)} instead.
	 */
	String subscribe(SubscriptionPayload payload, String tenantId);

	/**
	 * @deprecated Use {@link DeploymentService#subscribe(String, java.util.Map)} instead.
	 */
	String asyncSubscribe(SubscriptionPayload payload, String tenantId, String callbackUrl);

	/**
	 * @deprecated Use {@link DeploymentService#subscribe(String, java.util.Map)} instead.
	 */
	void finishAsyncSubscribe(SidecarSubscribeCallBackPayload payload);

	/**
	 * @deprecated Use {@link DeploymentService#unsubscribe(String, java.util.Map)} instead.
	 */
	void unsubscribe(DeletePayload payload, String tenantId);

	/**
	 * @deprecated Use {@link DeploymentService#unsubscribe(String, java.util.Map)} instead.
	 */
	void asyncUnsubscribe(DeletePayload payload, String tenantId, String callbackUrl);

	/**
	 * @deprecated Use {@link DeploymentService#unsubscribe(String, java.util.Map)} instead.
	 */
	void finishAsyncUnsubscribe(SidecarUnSubscribeCallBackPayload payload);

	/**
	 * @deprecated Use {@link DeploymentService#upgrade(java.util.List, java.util.Map)} instead.
	 */
	void deploy(SidecarUpgradePayload payload);

	/**
	 * @deprecated Use {@link DeploymentService#upgrade(java.util.List, java.util.Map)} instead.
	 */
	String asyncDeploy(SidecarUpgradePayload payload);

	/**
	 * @deprecated Use {@link DeploymentService#upgrade(java.util.List, java.util.Map)} instead.
	 */
	String asyncDeploy(SidecarUpgradePayload payload, String authorizationHeader);

	/**
	 * @deprecated Use {@link DeploymentService#upgrade(java.util.List, java.util.Map)} instead.
	 */
	String asyncDeployStatus(String jobId);

	/**
	 * @deprecated Use {@link DeploymentService#upgrade(java.util.List, java.util.Map)} instead.
	 */
	String asyncDeployStatus(String jobId, String authorizationHeader);

}
