package com.sap.cds.services.mt;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;

public interface SaasRegistryDependency extends CdsData {

	/**
	 * Creates a new {@link SaasRegistryDependency} instance
	 * @return the {@link SaasRegistryDependency} instance
	 */
	public static SaasRegistryDependency create() {
		return Struct.create(SaasRegistryDependency.class);
	}

	/**
	 * Creates a new {@link SaasRegistryDependency} instance with the given xsappname
	 * @param xsappname the xsappname of the required service
	 * @return the new {@link SaasRegistryDependency} instance
	 */
	public static SaasRegistryDependency create(String xsappname) {
		SaasRegistryDependency dependency = create();
		dependency.setXsappname(xsappname);
		return dependency;
	}

	/**
	 * @return the xsappname of the required service
	 */
	public String getXsappname();

	/**
	 * Sets the xsappname of the required service
	 * @param xsappname the xsappname of the required service
	 */
	public void setXsappname(String xsappname);

	/**
	 * @return the appId of the required service
	 * @deprecated Use {@link #getXsappname()} instead
	 */
	@Deprecated
	public String getAppId();

	/**
	 * Sets the appId of the required service
	 * @param appId the appId of the required service
	 * @deprecated Use {@link #setXsappname(String)} instead
	 */
	@Deprecated
	public void setAppId(String appId);

	/**
	 * @return the appName of the required service
	 * @deprecated Use {@link #getXsappname()} instead
	 */
	@Deprecated
	public String getAppName();

	/**
	 * Sets the appName of the required service
	 * @param appName the appName of the required service
	 * @deprecated Use {@link #setXsappname(String)} instead
	 */
	@Deprecated
	public void setAppName(String appName);
}
