/*********************************************************************
 * (C) 2023 SAP SE or an SAP affiliate company. All rights reserved. *
 *********************************************************************/
package com.sap.cds.services.mt;

import java.util.Map;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;

/**
 * Payload used for the callback to the SMS (Subscription Manager Service).
 */
public interface SmsCallback extends CdsData {

	static SmsCallback create() {
		return Struct.create(SmsCallback.class);
	}

	static SmsCallback create(Map<String, Object> attributes) {
		return Struct.access(attributes).as(SmsCallback.class);
	}

	/**
	 * Gets the status.
	 * 
	 * @return SUCCEEDED or FAILED
	 */
	String getStatus();

	/**
	 * Sets the status.
	 * 
	 * @param status SUCCEEDED or FAILED
	 */
	void setStatus(String status);

	/**
	 * Gets the success/failure message.
	 * 
	 * @return the message
	 */
	String getMessage();

	/**
	 * Sets the success/failure message.
	 * 
	 * @param message the message
	 */
	void setMessage(String message);

	/**
	 * Gets the application url.
	 * 
	 * @return the application url
	 */
	String getApplicationUrl();

	/**
	 * Sets the application url.
	 * 
	 * @param url the application url
	 */
	void setApplicationUrl(String url);
}
