/*********************************************************************
 * (C) 2023 SAP SE or an SAP affiliate company. All rights reserved. *
 *********************************************************************/
package com.sap.cds.services.mt;

import java.util.Map;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;

/**
 * An SMS (Subscription Manager Service) root application.
 */
public interface SmsRootApplication extends CdsData {

	static SmsRootApplication create() {
		return Struct.create(SmsRootApplication.class);
	}

	static SmsRootApplication create(Map<String, Object> attributes) {
		return Struct.access(attributes).as(SmsRootApplication.class);
	}

	/**
	 * Gets the IAS service instance id.
	 * 
	 * @return the IAS service instance id
	 */
	String getIasServiceInstanceId();

	/**
	 * Sets the IAS service instance id.
	 * 
	 * @param id the service instance id
	 */
	void setIasServiceInstanceId(String id);

	/**
	 * Gets the application display name.
	 * 
	 * @return the display name
	 */
	String getAppDisplayName();

	/**
	 * Sets the application display name.
	 * 
	 * @param name the display name
	 */
	void setAppDisplayName(String name);

	/**
	 * Gets the application name.
	 * 
	 * @return the app name
	 */
	String getAppName();

	/**
	 * Sets the application name.
	 * 
	 * @param name the app name
	 */
	void setAppName(String name);

	/**
	 * Gets the commercial application name
	 * 
	 * @return the app name
	 */
	String getCommercialAppName();

	/**
	 * Sets the commercial application name.
	 * 
	 * @param name the app name
	 */
	void setCommercialAppName(String name);

	/**
	 * Gets the id of the provider subaccount.
	 * 
	 * @return the provider subaccount id
	 */
	String getProviderSubaccountId();

	/**
	 * Sets the id of the provider subaccount.
	 * 
	 * @param id the provider subaccount id
	 */
	void setProviderSubaccountId(String id);

}
