/*********************************************************************
 * (C) 2023 SAP SE or an SAP affiliate company. All rights reserved. *
 *********************************************************************/
package com.sap.cds.services.mt;

import java.util.Map;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;

/**
 * An SMS (Subscription Manager Service) service instance.
 */
public interface SmsServiceInstance extends CdsData {

	static SmsServiceInstance create() {
		return Struct.create(SmsServiceInstance.class);
	}

	static SmsServiceInstance create(Map<String, Object> attributes) {
		return Struct.access(attributes).as(SmsServiceInstance.class);
	}

	/**
	 * Gets the IAS service instance id.
	 * 
	 * @return the IAS service instance id
	 */
	String getIasServiceInstanceId();

	/**
	 * Sets the IAS service instance id.
	 * 
	 * @param id the IAS service instance id
	 */
	void setIasServiceInstanceId(String id);

	/**
	 * Gets the application display name.
	 * 
	 * @return the app name
	 */
	String getAppDisplayName();

	/**
	 * Sets the application display name
	 * 
	 * @param name the app name
	 */
	void setAppDisplayName(String name);
}
