/*********************************************************************
 * (C) 2023 SAP SE or an SAP affiliate company. All rights reserved. *
 *********************************************************************/
package com.sap.cds.services.mt;

import java.util.Map;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;

/**
 * The payload for a subscription request from the SMS (Subscription Manager
 * Service).
 */
public interface SmsSubscriptionRequest extends CdsData {

	static SmsSubscriptionRequest create() {
		return Struct.create(SmsSubscriptionRequest.class);
	}

	static SmsSubscriptionRequest create(Map<String, Object> attributes) {
		return Struct.access(attributes).as(SmsSubscriptionRequest.class);
	}

	SmsSubscriber getSubscriber();

	void setSubscriber(SmsSubscriber subscriber);

	SmsRootApplication getRootApplication();

	void setRootApplication(SmsRootApplication rootApplication);

	SmsServiceInstance getOwnServiceInstance();

	void setOwnServiceInstance(SmsServiceInstance serviceInstance);

	String getEventType();

	void setEventType(String eventType);
}
