/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.subscription;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.feature.mt.ExecutorUtils;
import com.sap.cds.feature.mt.SaasClient;
import com.sap.cds.mtx.impl.Authenticator;
import com.sap.cds.mtx.impl.ClientCredentialJwtAccess;
import com.sap.cds.mtx.impl.ClientCredentialJwtReader;
import com.sap.cds.mtx.impl.XsuaaParams;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.mt.DeploymentService;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cloud.mt.subscription.SaasRegistry;
import com.sap.cloud.mt.subscription.ServiceSpecification;
import com.sap.cloud.mt.subscription.UiUrlCreator;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import com.sap.cloud.mt.tools.api.RequestEnhancer;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaasProvisioningServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(SaasProvisioningServlet.class);
    public static final String HEADER_STATUS_CALLBACK = "STATUS_CALLBACK";
    private static final String DEPENDENCIES = "/dependencies";
    private static final String TENANTS = "/tenants/";
    private static final String FALLBACK_APP_URL = "tenant successfully subscribed - no application URL provided";
    private final CdsRuntime runtime;
    private final DeploymentService deploymentService;
    private final SaasRegistry saasRegistry;

    public SaasProvisioningServlet(CdsRuntime runtime) {
        this.runtime = runtime;
        this.deploymentService = (DeploymentService)runtime.getServiceCatalog().getService(DeploymentService.class, "DeploymentService$Default");
        this.saasRegistry = SaasClient.findBinding(runtime).map(saasBinding -> {
            logger.info("Asynchronous subscription for saas-registry service '{}' available", saasBinding.getName().get());
            Map credentials = saasBinding.getCredentials();
            ClientCredentialJwtAccess authenticator = new ClientCredentialJwtAccess(new ClientCredentialJwtReader(new XsuaaParams(credentials)));
            RequestEnhancer authenticationEnhancer = arg_0 -> SaasProvisioningServlet.lambda$new$0((Authenticator)authenticator, arg_0);
            String saasRegistryUrl = (String)credentials.get("saas_registry_url");
            DefaultDestinationLoader loader = new DefaultDestinationLoader();
            loader.registerDestination((HttpDestination)DefaultHttpDestination.builder((String)saasRegistryUrl).name("com.sap.cds.saasRegistry").build());
            DestinationAccessor.prependDestinationLoader((DestinationLoader)loader);
            return new SaasRegistry(ServiceSpecification.Builder.create().requestEnhancer(authenticationEnhancer).build());
        }).orElse(null);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        this.processRequest(req, res, p -> DEPENDENCIES.equals(p), () -> {
            this.checkAuthorization();
            List dependencies = this.deploymentService.dependencies();
            SaasProvisioningServlet.setContentType(res, ContentType.APPLICATION_JSON);
            res.setStatus(200);
            res.getWriter().write(mapper.writeValueAsString((Object)dependencies));
        });
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) {
        this.processRequest(req, res, p -> p.startsWith(TENANTS), () -> {
            this.checkAuthorization();
            String tenantId = SaasProvisioningServlet.getTenantId(req);
            logger.info("Creating subscription for tenant '{}'", (Object)tenantId);
            Map<String, Object> payload = SaasProvisioningServlet.toMap((InputStream)req.getInputStream());
            String callbackUrl = req.getHeader(HEADER_STATUS_CALLBACK);
            if (callbackUrl != null) {
                logger.debug("Processing subscription for tenant '{}' asynchronously", (Object)tenantId);
                long startTime = System.currentTimeMillis();
                ExecutorUtils.runAsynchronously(this.runtime, () -> {
                    boolean success = false;
                    try {
                        this.deploymentService.subscribe(tenantId, payload);
                        success = true;
                        logger.info("Subscription for tenant '{}' finished successfully", (Object)tenantId);
                    }
                    catch (Throwable e) {
                        logger.error("Subscription for tenant '{}' failed", (Object)tenantId, (Object)e);
                    }
                    try {
                        SaasProvisioningServlet.handleSaasRegistryRaceCondition(startTime);
                        this.saasRegistry.callBackSaasRegistry(success, success ? "Subscription succeeded" : "Subscription failed", this.getAppUiUrl(payload), callbackUrl);
                    }
                    catch (Throwable e) {
                        logger.error("Failed to report status for tenant '{}' to SaaS Registry", (Object)tenantId, (Object)e);
                    }
                });
                res.setStatus(202);
            } else {
                logger.debug("Processing subscription for tenant '{}' synchronously", (Object)tenantId);
                this.deploymentService.subscribe(tenantId, payload);
                res.setStatus(201);
                SaasProvisioningServlet.setContentType(res, ContentType.TEXT_PLAIN);
                res.getWriter().write(this.getAppUiUrl(payload));
            }
        });
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse res) {
        this.processRequest(req, res, p -> p.startsWith(TENANTS), () -> {
            this.checkAuthorization();
            String tenantId = SaasProvisioningServlet.getTenantId(req);
            logger.info("Deleting subscription for tenant '{}'", (Object)tenantId);
            Map<String, Object> payload = SaasProvisioningServlet.toMap((InputStream)req.getInputStream());
            String callbackUrl = req.getHeader(HEADER_STATUS_CALLBACK);
            if (callbackUrl != null) {
                logger.debug("Processing unsubscription for tenant '{}' asynchronously", (Object)tenantId);
                long startTime = System.currentTimeMillis();
                ExecutorUtils.runAsynchronously(this.runtime, () -> {
                    boolean success = false;
                    try {
                        this.deploymentService.unsubscribe(tenantId, payload);
                        success = true;
                        logger.info("Unsubscription for tenant '{}' finished successfully", (Object)tenantId);
                    }
                    catch (Throwable e) {
                        logger.error("Unsubscription for tenant '{}' failed", (Object)tenantId, (Object)e);
                    }
                    try {
                        SaasProvisioningServlet.handleSaasRegistryRaceCondition(startTime);
                        this.saasRegistry.callBackSaasRegistry(success, success ? "Removing subscription succeeded" : "Removing subscription failed", null, callbackUrl);
                    }
                    catch (Throwable e) {
                        logger.error("Failed to report status for tenant '{}' to SaaS Registry", (Object)tenantId, (Object)e);
                    }
                });
                res.setStatus(202);
            } else {
                logger.debug("Processing unsubscription for tenant '{}' synchronously", (Object)tenantId);
                this.deploymentService.unsubscribe(tenantId, payload);
                res.setStatus(204);
            }
        });
    }

    private void checkAuthorization() {
        RequestContext requestContext = RequestContext.getCurrent((CdsRuntime)this.runtime);
        if (requestContext.getUserInfo().isPrivileged() || requestContext.getUserInfo().isInternalUser()) {
            return;
        }
        String callbackScope = this.runtime.getEnvironment().getCdsProperties().getMultiTenancy().getSecurity().getSubscriptionScope();
        if (!requestContext.getUserInfo().hasRole(callbackScope)) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.FORBIDDEN, new Object[0]);
        }
    }

    private static String getTenantId(HttpServletRequest req) {
        String tenantId = req.getPathInfo().split("/")[2];
        if (StringUtils.isEmpty((String)tenantId)) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_FOUND, new Object[0]);
        }
        return tenantId;
    }

    private static void setContentType(HttpServletResponse resp, ContentType contType) {
        resp.setContentType(contType.getMimeType());
        resp.setCharacterEncoding(contType.getCharset().toString());
    }

    private static Map<String, Object> toMap(InputStream stream) throws IOException {
        try {
            TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
            return (Map)mapper.readValue(stream, (TypeReference)typeRef);
        }
        catch (DatabindException e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[]{e});
        }
    }

    private static void handleSaasRegistryRaceCondition(long startTime) {
        long raceConditionWaitTime = 10000L;
        long elapsed = System.currentTimeMillis() - startTime;
        if (elapsed < raceConditionWaitTime) {
            try {
                Thread.sleep(Math.max(raceConditionWaitTime - elapsed, 0L));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private String getAppUiUrl(Map<String, Object> payload) {
        try {
            CdsProperties.MultiTenancy.AppUi appUi = this.runtime.getEnvironment().getCdsProperties().getMultiTenancy().getAppUi();
            String configuredUrl = UiUrlCreator.createUrl((String)((String)payload.get("subscribedSubdomain")), (String)appUi.getUrl(), (String)appUi.getTenantSeparator());
            return StringUtils.isEmpty((String)configuredUrl) ? FALLBACK_APP_URL : configuredUrl;
        }
        catch (InternalError e) {
            throw new RuntimeException(e);
        }
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse res, Predicate<String> pathMatcher, Processor processor) {
        if (pathMatcher.test(req.getPathInfo())) {
            this.runtime.requestContext().modifyUser(user -> user.setTenant(null)).featureToggles(FeatureTogglesInfo.all()).run(requestContext -> {
                block13: {
                    try {
                        processor.process();
                    }
                    catch (ServiceException e) {
                        if (e.getErrorStatus().getHttpStatus() >= 500 && e.getErrorStatus().getHttpStatus() < 600) {
                            logger.error("Unexpected error", (Throwable)e);
                        } else {
                            logger.debug("Service exception thrown", (Throwable)e);
                        }
                        res.setStatus(e.getErrorStatus().getHttpStatus());
                        try {
                            String message = e.getLocalizedMessage(requestContext.getParameterInfo().getLocale());
                            if (message == null) break block13;
                            try (PrintWriter writer = res.getWriter();){
                                writer.write(message);
                            }
                        }
                        catch (IOException e1) {
                            logger.error("Failed to write error message to response", (Throwable)e1);
                        }
                    }
                    catch (Throwable t) {
                        logger.error("Unexpected error", t);
                        res.setStatus(500);
                    }
                }
            });
        } else {
            res.setStatus(404);
        }
    }

    private static /* synthetic */ void lambda$new$0(Authenticator authenticator, HttpUriRequest request) throws Exception {
        request.addHeader("Authorization", (String)authenticator.getAuthorization().get());
    }

    @FunctionalInterface
    private static interface Processor {
        public void process() throws IOException;
    }
}

