/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.mt.impl;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.mt.ReadTenantsEventContext;
import com.sap.cds.services.mt.TenantInfo;
import com.sap.cds.services.mt.TenantProviderService;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cloud.mt.subscription.InstanceLifecycleManager;
import com.sap.cloud.mt.subscription.TenantMetadata;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@ServiceName(value={"TenantProviderService$Default"}, type={TenantProviderService.class})
public class MtTenantProviderHandler
implements EventHandler {
    private static final String DATABASE_ID_ADDED = "database_id_added";
    private final InstanceLifecycleManager ilm;

    public MtTenantProviderHandler(InstanceLifecycleManager ilm) {
        this.ilm = ilm;
    }

    @On
    @HandlerOrder(value=10901)
    public void readTenants(ReadTenantsEventContext context) {
        try {
            context.put(DATABASE_ID_ADDED, (Object)true);
            context.setResult(this.ilm.getAllTenantInfos(true).values().stream().map(this::toTenantInfo).collect(Collectors.toList()));
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.TENANT_READ_FAILED, new Object[]{e});
        }
    }

    @After
    public void enrichTenants(ReadTenantsEventContext context) {
        Object dbIdAdded = context.get(DATABASE_ID_ADDED);
        if (Boolean.TRUE.equals(dbIdAdded)) {
            return;
        }
        try {
            Map smTenants = this.ilm.getAllTenantInfos(false);
            List tenantInfo = context.getResult();
            tenantInfo.forEach(tenant -> {
                if (smTenants.containsKey(tenant.getTenant())) {
                    MtTenantProviderHandler.addDatabaseId((TenantMetadata)smTenants.get(tenant.getTenant()), tenant);
                }
            });
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.TENANT_READ_FAILED, new Object[]{e});
        }
    }

    private static void addDatabaseId(TenantMetadata smTenant, TenantInfo tenant) {
        Map props = smTenant.getAdditionalProperties();
        if (props != null && props.containsKey("database_id")) {
            tenant.put((Object)"database_id", props.get("database_id"));
        }
    }

    private TenantInfo toTenantInfo(TenantMetadata tenant) {
        TenantInfo info = TenantInfo.create();
        info.setTenant(tenant.getTenantId());
        MtTenantProviderHandler.addDatabaseId(tenant, info);
        return info;
    }
}

