/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription;

import com.sap.cds.feature.mt.lib.subscription.DbDeployerLiquibase;
import com.sap.cds.feature.mt.lib.subscription.HanaEncryptionTool;
import com.sap.cds.feature.mt.lib.subscription.HdiContainerManager;
import com.sap.cds.feature.mt.lib.subscription.InstanceLifecycleManager;
import com.sap.cds.feature.mt.lib.subscription.LiquibaseParameters;
import com.sap.cds.feature.mt.lib.subscription.ProvisioningService;
import com.sap.cds.feature.mt.lib.subscription.SaasRegistry;
import com.sap.cds.feature.mt.lib.subscription.SecurityChecker;
import com.sap.cds.feature.mt.lib.subscription.Subscriber;
import com.sap.cds.feature.mt.lib.subscription.SubscriberImpl;
import com.sap.cds.feature.mt.lib.subscription.SubscriberStreamlinedMtx;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import com.sap.cds.feature.mt.lib.subscription.exits.Exits;
import com.sap.cds.services.utils.lib.tools.api.ResilienceConfig;
import org.apache.commons.lang3.StringUtils;

public class SubscriberBuilder {
    private String baseUiUrl;
    private String urlSeparator;
    private Exits exits;
    private SecurityChecker securityChecker;
    private SaasRegistry saasRegistry;
    private InstanceLifecycleManager instanceLifecycleManager;
    private HdiContainerManager hdiContainerManager;
    private LiquibaseParameters liquibaseParameters;
    private ProvisioningService provisioningService;
    private boolean withoutAuthorityCheck = false;
    private HanaEncryptionTool.DbEncryptionMode hanaEncryptionMode;
    private ResilienceConfig resilienceConfig = ResilienceConfig.NONE;

    private SubscriberBuilder() {
    }

    public static SubscriberBuilder create() {
        return new SubscriberBuilder();
    }

    public Subscriber build() throws InternalError {
        if (this.provisioningService != null) {
            return SubscriberStreamlinedMtx.Builder.create().provisioningService(this.provisioningService).baseUiUrl(this.baseUiUrl).urlSeparator(this.urlSeparator).exits(this.exits).securityChecker(this.securityChecker).saasRegistry(this.saasRegistry).instanceLifecycleManager(this.instanceLifecycleManager).withoutAuthorityCheck(this.withoutAuthorityCheck).hanaEncryptionMode(this.hanaEncryptionMode).build();
        }
        if (this.hdiContainerManager != null) {
            return new SubscriberImpl(this.instanceLifecycleManager, this.hdiContainerManager, this.baseUiUrl, this.urlSeparator, this.exits, this.securityChecker, this.saasRegistry, this.withoutAuthorityCheck, this.hanaEncryptionMode, this.resilienceConfig);
        }
        if (this.liquibaseParameters != null && (StringUtils.isNotBlank((CharSequence)this.liquibaseParameters.getFileName()) || this.liquibaseParameters.getResourceAccessor() != null)) {
            DbDeployerLiquibase dbDeployer = new DbDeployerLiquibase(this.liquibaseParameters);
            return new SubscriberImpl(this.instanceLifecycleManager, dbDeployer, this.baseUiUrl, this.urlSeparator, this.exits, this.securityChecker, this.saasRegistry, this.withoutAuthorityCheck, this.hanaEncryptionMode, this.resilienceConfig);
        }
        throw new InternalError("Could not create subscriber");
    }

    public SubscriberBuilder baseUiUrl(String baseUiUrl) {
        this.baseUiUrl = baseUiUrl;
        return this;
    }

    public SubscriberBuilder urlSeparator(String urlSeparator) {
        this.urlSeparator = urlSeparator;
        return this;
    }

    public SubscriberBuilder exits(Exits exits) {
        this.exits = exits;
        return this;
    }

    public SubscriberBuilder securityChecker(SecurityChecker securityChecker) {
        this.securityChecker = securityChecker;
        return this;
    }

    public SubscriberBuilder saasRegistry(SaasRegistry saasRegistry) {
        this.saasRegistry = saasRegistry;
        return this;
    }

    public SubscriberBuilder instanceLifecycleManager(InstanceLifecycleManager instanceLifecycleManager) {
        this.instanceLifecycleManager = instanceLifecycleManager;
        return this;
    }

    public SubscriberBuilder hdiContainerManager(HdiContainerManager hdiContainerManager) {
        this.hdiContainerManager = hdiContainerManager;
        return this;
    }

    public SubscriberBuilder liquibaseParameters(LiquibaseParameters liquibaseParameters) {
        this.liquibaseParameters = liquibaseParameters;
        return this;
    }

    public SubscriberBuilder provisioningService(ProvisioningService provisioningService) {
        this.provisioningService = provisioningService;
        return this;
    }

    public SubscriberBuilder withoutAuthorityCheck(boolean withoutAuthorityCheck) {
        this.withoutAuthorityCheck = withoutAuthorityCheck;
        return this;
    }

    public SubscriberBuilder hanaEncryptionMode(HanaEncryptionTool.DbEncryptionMode hanaEncryptionMode) {
        this.hanaEncryptionMode = hanaEncryptionMode;
        return this;
    }

    public SubscriberBuilder resilienceConfig(ResilienceConfig resilienceConfig) {
        this.resilienceConfig = resilienceConfig;
        return this;
    }
}

