/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription;

import com.sap.cds.feature.mt.lib.subscription.DbCredentials;
import com.sap.cds.feature.mt.lib.subscription.DbCredentialsBuilder;
import com.sap.cds.feature.mt.lib.subscription.DbIdentifiers;
import com.sap.cds.feature.mt.lib.subscription.DbIdentifiersHana;
import com.sap.cds.feature.mt.lib.subscription.DbIdentifiersSqLite;
import com.sap.cds.feature.mt.lib.subscription.DbIdentifiersSql;
import com.sap.cds.feature.mt.lib.subscription.InstanceLifecycleManager;
import com.sap.cds.feature.mt.lib.subscription.InstanceLifecycleManagerImpl;
import com.sap.cds.feature.mt.lib.subscription.InstanceLifecycleManagerSqLite;
import com.sap.cds.feature.mt.lib.subscription.InstanceLifecycleManagerSqlDb;
import com.sap.cds.feature.mt.lib.subscription.ServiceManager;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import com.sap.cds.services.utils.lib.tools.api.ResilienceConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InstanceLifecycleManagerBuilder {
    private ServiceManager serviceManager;
    private DbIdentifiers dbIdentifiers;
    private List<DbCredentials> dbCredentialsList = new ArrayList<DbCredentials>();
    private DbIdentifiers.DB db = DbIdentifiers.DB.NONE;
    private Duration smCacheRefreshInterval;
    private ResilienceConfig serviceManagerCacheResilienceConfig = ResilienceConfig.NONE;
    private static ConcurrentHashMap<String, InstanceLifecycleManagerImpl> smIdToILM = new ConcurrentHashMap();
    private boolean acceptInstancesWithoutTenant;
    private boolean ignoreDuplicateTenantInstances;
    private Duration singleReadInterval = Duration.ZERO;

    public InstanceLifecycleManager build() throws InternalError {
        if (this.serviceManager != null) {
            if (this.dbIdentifiers != null && !(this.dbIdentifiers instanceof DbIdentifiersHana)) {
                throw new InternalError("Hana database specified with database identifiers of non-HANA DB");
            }
            if (this.dbIdentifiers == null) {
                this.dbIdentifiers = new DbIdentifiersHana(new HashSet<String>());
            }
            return smIdToILM.computeIfAbsent(this.serviceManager.getServiceInstanceName(), id -> new InstanceLifecycleManagerImpl(this.serviceManager, (DbIdentifiersHana)this.dbIdentifiers, this.smCacheRefreshInterval, this.serviceManagerCacheResilienceConfig, this.acceptInstancesWithoutTenant, this.ignoreDuplicateTenantInstances, this.singleReadInterval));
        }
        if (this.dbIdentifiers != null) {
            DbIdentifiers dbIdentifiers = this.dbIdentifiers;
            if (dbIdentifiers instanceof DbIdentifiersSql) {
                DbIdentifiersSql dbIdentifiersSql = (DbIdentifiersSql)dbIdentifiers;
                return new InstanceLifecycleManagerSqlDb(dbIdentifiersSql);
            }
            dbIdentifiers = this.dbIdentifiers;
            if (dbIdentifiers instanceof DbIdentifiersSqLite) {
                DbIdentifiersSqLite dbIdentifiersSqLite = (DbIdentifiersSqLite)dbIdentifiers;
                return new InstanceLifecycleManagerSqLite(dbIdentifiersSqLite.getRoot());
            }
            throw new InternalError("No database credentials provided");
        }
        if (!this.dbCredentialsList.isEmpty()) {
            if (this.db == DbIdentifiers.DB.NONE) {
                throw new InternalError("No database type set");
            }
            return new InstanceLifecycleManagerSqlDb(new DbIdentifiersSql(this.dbCredentialsList));
        }
        throw new InternalError("No instance manager, service manager or databases specified");
    }

    public static InstanceLifecycleManagerBuilder create() {
        return new InstanceLifecycleManagerBuilder();
    }

    private InstanceLifecycleManagerBuilder() {
    }

    public InstanceLifecycleManagerBuilder serviceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
        return this;
    }

    public InstanceLifecycleManagerBuilder dbIdentifiers(DbIdentifiers dbIdentifiers) {
        this.dbIdentifiers = dbIdentifiers;
        return this;
    }

    public InstanceLifecycleManagerBuilder addDbCredentials(Map<String, Object> credentials) throws InternalError {
        return this.addDbCredentials(DbIdentifiers.DB.NONE, credentials);
    }

    public InstanceLifecycleManagerBuilder smCacheRefreshInterval(Duration smCacheRefreshInterval) {
        this.smCacheRefreshInterval = smCacheRefreshInterval;
        return this;
    }

    public InstanceLifecycleManagerBuilder addDbCredentials(DbIdentifiers.DB db, Map<String, Object> credentials) throws InternalError {
        DbCredentialsBuilder dbCredentialsBuilder = DbCredentialsBuilder.create().db(db).credentials(credentials);
        DbCredentials dbCredentials = dbCredentialsBuilder.build();
        this.dbCredentialsList.add(dbCredentials);
        if (this.db != DbIdentifiers.DB.NONE && this.db != dbCredentials.getDB()) {
            throw new InternalError("It is not possible to combine different types of databases for multi tenancy");
        }
        if (this.db == DbIdentifiers.DB.NONE) {
            this.db = dbCredentials.getDB();
        }
        return this;
    }

    public InstanceLifecycleManagerBuilder smCacheResilienceConfig(ResilienceConfig resilienceConfig) {
        if (resilienceConfig != null) {
            this.serviceManagerCacheResilienceConfig = resilienceConfig;
        }
        return this;
    }

    public InstanceLifecycleManagerBuilder acceptInstancesWithoutTenant(boolean acceptInstancesWithoutTenant) {
        this.acceptInstancesWithoutTenant = acceptInstancesWithoutTenant;
        return this;
    }

    public InstanceLifecycleManagerBuilder ignoreDuplicateTenantInstances(boolean ignoreDuplicateTenantInstances) {
        this.ignoreDuplicateTenantInstances = ignoreDuplicateTenantInstances;
        return this;
    }

    public InstanceLifecycleManagerBuilder singleReadInterval(Duration singleReadInterval) {
        this.singleReadInterval = singleReadInterval;
        return this;
    }
}

