/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.feature.mt.lib.subscription.BindingParameters;
import com.sap.cds.feature.mt.lib.subscription.PollingParameters;
import com.sap.cds.feature.mt.lib.subscription.ProvisioningParameters;
import com.sap.cds.feature.mt.lib.subscription.ServiceBinding;
import com.sap.cds.feature.mt.lib.subscription.ServiceInstance;
import com.sap.cds.feature.mt.lib.subscription.ServiceOperation;
import com.sap.cds.feature.mt.lib.subscription.ServiceSpecification;
import com.sap.cds.feature.mt.lib.subscription.Tools;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import com.sap.cds.services.utils.environment.ServiceBindingUtils;
import com.sap.cds.services.utils.lib.tools.api.QueryParameter;
import com.sap.cds.services.utils.lib.tools.api.ServiceCall;
import com.sap.cds.services.utils.lib.tools.api.ServiceEndpoint;
import com.sap.cds.services.utils.lib.tools.api.ServiceResponse;
import com.sap.cds.services.utils.lib.tools.exception.InternalException;
import com.sap.cds.services.utils.lib.tools.exception.ServiceException;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultOAuth2PropertySupplier;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2Options;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.security.config.ClientCertificate;
import com.sap.cloud.security.config.ClientCredentials;
import com.sap.cloud.security.config.ClientIdentity;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceManager {
    public static final String SM_URL = "sm_url";
    public static final String TOKEN = "token";
    public static final Map<String, String> CALLED_FROM;
    private static final Logger logger;
    private static final String SERVICE_INSTANCES_ENDPOINT = "/v1/service_instances";
    private static final String SERVICE_BINDINGS_ENDPOINT = "/v1/service_bindings";
    private static final String SERVICE_PLANS_ENDPOINT = "/v1/service_plans";
    private static final String SERVICE_OFFERINGS_ENDPOINT = "/v1/service_offerings";
    private static final String FIELD_QUERY = "fieldQuery";
    private static final String LABEL_QUERY = "labelQuery";
    private static final String ID = "id";
    private static final String ITEMS = "items";
    private static final String SERVICE_INSTANCES_ENDPOINT_V2 = "/v2/service_instances";
    private static final String SERVICE_BINDINGS_ENDPOINT_V2 = "/v2/service_bindings";
    private static final String SERVICE_OFFERINGS_ENDPOINT_V2 = "/v2/service_offerings";
    private static final String SERVICE_PLANS_ENDPOINT_V2 = "/v2/service_plans";
    public static final String UNEXPECTED_RETURN_CODE = "unexpected return code %d";
    public static final String ASYNC = "async";
    public static final String SUCCEEDED = "succeeded";
    public static final String IN_PROGRESS = "in progress";
    public static final String FAILED = "failed";
    public static final String LOCATION = "location";
    public static final String INSTANCE_ID_IS_EMPTY = "Instance id is empty";
    public static final String TENANT_ID = "tenant_id";
    public static final String MANAGING_CLIENT_LIB = "managing_client_lib";
    public static final String SERVICE_PLAN_ID = "service_plan_id";
    public static final String INSTANCE_MANAGER_CLIENT_LIB = "instance-manager-client-lib";
    public static final String TENANT_ID_IS_EMPTY = "Tenant id is empty";
    public static final String ATTACH_LAST_OPERATIONS = "attach_last_operations";
    private final ObjectMapper mapper = new ObjectMapper();
    private final ConcurrentHashMap<String, String> planIdMap = new ConcurrentHashMap();
    private final ServiceEndpoint instancesEndpoint;
    private final ServiceEndpoint bindingsEndpoint;
    private final ServiceEndpoint oneInstanceEndpoint;
    private final ServiceEndpoint oneBindingEndpoint;
    private final ServiceEndpoint instancesAsyncEndpoint;
    private final ServiceEndpoint bindingsAsyncEndpoint;
    private final ServiceEndpoint plansEndpoint;
    private final ServiceEndpoint offeringsEndpoint;
    private final ServiceEndpoint locationEndpoint;
    private final ServiceEndpoint instancesEndpointV2;
    private final ServiceEndpoint bindingsEndpointV2;
    private final ServiceEndpoint oneInstanceEndpointV2;
    private final ServiceEndpoint oneBindingEndpointV2;
    private final ServiceEndpoint offeringsEndpointV2;
    private final ServiceEndpoint plansEndpointV2;
    private final String serviceOfferingName;
    private final String planName;
    private final ServiceSpecification serviceSpecification;
    private final String serviceInstanceName;
    private final boolean isV2;

    public ServiceManager(boolean isV2, com.sap.cloud.environment.servicebinding.api.ServiceBinding serviceBinding, ServiceSpecification serviceSpecification, String serviceOfferingName, String planName, Duration oauthTimeout) throws InternalError {
        this.isV2 = isV2;
        this.serviceOfferingName = serviceOfferingName;
        this.planName = planName;
        this.serviceSpecification = serviceSpecification;
        this.serviceInstanceName = (String)serviceBinding.getName().orElseThrow(() -> new InternalError("Service instance name is missing"));
        HashSet<Integer> retryCodes = new HashSet<Integer>();
        retryCodes.add(502);
        retryCodes.add(504);
        retryCodes.add(500);
        retryCodes.add(503);
        HashSet<Integer> retryCodesV2 = new HashSet<Integer>(retryCodes);
        retryCodesV2.add(429);
        HttpDestination destination = ServiceManager.getDestination(serviceBinding, oauthTimeout);
        try {
            this.offeringsEndpoint = this.createEndpoint(destination, SERVICE_OFFERINGS_ENDPOINT, new HashSet<Integer>(Arrays.asList(200)), retryCodes);
            this.plansEndpoint = this.createEndpoint(destination, SERVICE_PLANS_ENDPOINT, new HashSet<Integer>(Arrays.asList(200)), retryCodes);
            this.offeringsEndpointV2 = this.createEndpoint(destination, SERVICE_OFFERINGS_ENDPOINT_V2, new HashSet<Integer>(Arrays.asList(200)), retryCodesV2);
            this.plansEndpointV2 = this.createEndpoint(destination, SERVICE_PLANS_ENDPOINT_V2, new HashSet<Integer>(Arrays.asList(200)), retryCodesV2);
            this.instancesEndpoint = this.createEndpoint(destination, SERVICE_INSTANCES_ENDPOINT, new HashSet<Integer>(Arrays.asList(200, 201)), retryCodes);
            this.instancesEndpointV2 = this.createEndpoint(destination, SERVICE_INSTANCES_ENDPOINT_V2, new HashSet<Integer>(Arrays.asList(200, 201)), retryCodesV2);
            this.oneInstanceEndpoint = this.createEndpoint(destination, SERVICE_INSTANCES_ENDPOINT, new HashSet<Integer>(Arrays.asList(200, 404)), retryCodes);
            this.oneInstanceEndpointV2 = this.createEndpoint(destination, SERVICE_INSTANCES_ENDPOINT_V2, new HashSet<Integer>(Arrays.asList(200, 404)), retryCodesV2);
            this.bindingsEndpoint = this.createEndpoint(destination, SERVICE_BINDINGS_ENDPOINT, new HashSet<Integer>(Arrays.asList(200, 201)), retryCodes);
            this.bindingsEndpointV2 = this.createEndpoint(destination, SERVICE_BINDINGS_ENDPOINT_V2, new HashSet<Integer>(Arrays.asList(200, 201)), retryCodesV2);
            this.oneBindingEndpoint = this.createEndpoint(destination, SERVICE_BINDINGS_ENDPOINT, new HashSet<Integer>(Arrays.asList(200, 404)), retryCodes);
            this.oneBindingEndpointV2 = this.createEndpoint(destination, SERVICE_BINDINGS_ENDPOINT_V2, new HashSet<Integer>(Arrays.asList(200, 404)), retryCodesV2);
            this.instancesAsyncEndpoint = this.createEndpoint(destination, SERVICE_INSTANCES_ENDPOINT, new HashSet<Integer>(Arrays.asList(202)), retryCodes);
            this.bindingsAsyncEndpoint = this.createEndpoint(destination, SERVICE_BINDINGS_ENDPOINT, new HashSet<Integer>(Arrays.asList(202)), retryCodes);
            this.locationEndpoint = this.createEndpoint(destination, "", new HashSet<Integer>(Arrays.asList(200)), retryCodes);
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
    }

    public ServiceManager(com.sap.cloud.environment.servicebinding.api.ServiceBinding serviceBinding, ServiceSpecification serviceSpecification, String serviceOfferingName, String planName) throws InternalError {
        this(false, serviceBinding, serviceSpecification, serviceOfferingName, planName, null);
    }

    public List<ServiceInstance> readInstances() throws InternalError {
        return this.readInstances(null, null);
    }

    public Optional<ServiceInstance> readInstanceForTenant(String tenantId) throws InternalError {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw new InternalError(TENANT_ID_IS_EMPTY);
        }
        if (tenantId.startsWith("MT_LIB_TENANT-")) {
            return this.extractFirstInstance(this.readInstancesMaps(tenantId, null));
        }
        return this.extractServiceInstance(this.readInstancesMaps(tenantId, null), "Multiple instances found for tenant id %s".formatted(tenantId));
    }

    public Optional<ServiceInstance> readInstance(String instanceId) throws InternalError {
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            throw new InternalError(INSTANCE_ID_IS_EMPTY);
        }
        return this.extractServiceInstance(this.readInstancesMaps(null, instanceId), "Multiple instances found for instance id %s".formatted(instanceId));
    }

    public List<ServiceBinding> readBindings() throws InternalError {
        return this.readBindings(null, null, null);
    }

    public List<ServiceBinding> readBindingsForTenant(String tenantId) throws InternalError {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw new InternalError(TENANT_ID_IS_EMPTY);
        }
        return this.readBindings(tenantId, null, null);
    }

    public List<ServiceBinding> readBindingsForInstance(String instanceId) throws InternalError {
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            throw new InternalError(INSTANCE_ID_IS_EMPTY);
        }
        return this.readBindings(null, instanceId, null);
    }

    public Optional<ServiceBinding> readBinding(String bindingId) throws InternalError {
        return this.extractServiceBinding(this.readBindingsMaps(null, null, bindingId), "Multiple bindings found for binding id %s".formatted(bindingId));
    }

    public Optional<ServiceInstance> createInstance(String tenantId, ProvisioningParameters parameters) throws InternalError {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw new InternalError(TENANT_ID_IS_EMPTY);
        }
        HashMap<String, List<String>> labels = new HashMap<String, List<String>>();
        labels.put(TENANT_ID, Arrays.asList(tenantId));
        CreateInstancePayload payload = new CreateInstancePayload(this.getPlanId(), this.calculateServiceInstanceName(tenantId), parameters, labels);
        List<QueryParameter> query = Arrays.asList(new QueryParameter(ASYNC, "true"));
        try {
            ServiceCall createInstances = this.instancesAsyncEndpoint.createServiceCall().http().post().payload((Object)payload).noPathParameter().query(query).enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end();
            logger.debug("Call service manager to create service instances for tenant id {} and payload {}", (Object)tenantId, Tools.lazyJson(() -> payload));
            ServiceResponse response = createInstances.execute(Map.class);
            Optional<Header> locationHeader = Arrays.stream(response.getHeaders()).filter(h -> LOCATION.equalsIgnoreCase(h.getName())).findFirst();
            if (!locationHeader.isPresent()) {
                throw new InternalError("No location header returned for asynchronous create instance operation");
            }
            String locationUrl = locationHeader.get().getValue();
            String instanceId = this.waitForCompletionAndGetId(locationUrl, this.serviceSpecification.getPolling());
            return this.readInstance(instanceId);
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    public String deleteInstance(String instanceId) throws InternalError {
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            throw new InternalError(INSTANCE_ID_IS_EMPTY);
        }
        List<QueryParameter> query = Arrays.asList(new QueryParameter(ASYNC, "true"));
        try {
            ServiceCall deleteInstance = this.instancesAsyncEndpoint.createServiceCall().http().delete().withoutPayload().pathParameter(new String[]{instanceId}).query(query).enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end();
            logger.debug("Call service manager to delete service instance {} ", (Object)instanceId);
            ServiceResponse response = deleteInstance.execute(Map.class);
            Optional<Header> locationHeader = Arrays.stream(response.getHeaders()).filter(h -> LOCATION.equalsIgnoreCase(h.getName())).findFirst();
            if (!locationHeader.isPresent()) {
                throw new InternalError("No location header returned for asynchronous delete instance operation");
            }
            String locationUrl = locationHeader.get().getValue();
            return this.waitForCompletionAndGetId(locationUrl, this.serviceSpecification.getPolling());
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    public Optional<ServiceBinding> createBinding(String tenantId, String serviceInstanceId, BindingParameters parameters) throws InternalError {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw new InternalError(TENANT_ID_IS_EMPTY);
        }
        if (StringUtils.isBlank((CharSequence)serviceInstanceId)) {
            throw new InternalError("Service instance id is empty");
        }
        HashMap<String, List<String>> labels = new HashMap<String, List<String>>();
        labels.put(TENANT_ID, Arrays.asList(tenantId));
        labels.put(MANAGING_CLIENT_LIB, Arrays.asList(INSTANCE_MANAGER_CLIENT_LIB));
        labels.put(SERVICE_PLAN_ID, Arrays.asList(this.getPlanId()));
        CreateBindingPayload payload = new CreateBindingPayload(serviceInstanceId, UUID.randomUUID().toString(), parameters, labels);
        List<QueryParameter> query = Arrays.asList(new QueryParameter(ASYNC, "true"));
        try {
            ServiceCall createBindings = this.bindingsAsyncEndpoint.createServiceCall().http().post().payload((Object)payload).noPathParameter().query(query).enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end();
            logger.debug("Call service manager to create new binding with payload {}", Tools.lazyJson(() -> payload));
            ServiceResponse response = createBindings.execute(Map.class);
            Optional<Header> locationHeader = Arrays.stream(response.getHeaders()).filter(h -> LOCATION.equalsIgnoreCase(h.getName())).findFirst();
            if (!locationHeader.isPresent()) {
                throw new InternalError("No location header returned for asynchronous create binding operation");
            }
            String locationUrl = locationHeader.get().getValue();
            String bindingId = this.waitForCompletionAndGetId(locationUrl, this.serviceSpecification.getPolling());
            return this.readBinding(bindingId);
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    public String deleteBinding(String bindingId) throws InternalError {
        if (StringUtils.isBlank((CharSequence)bindingId)) {
            throw new InternalError("Binding id is empty");
        }
        List<QueryParameter> query = Arrays.asList(new QueryParameter(ASYNC, "true"));
        try {
            ServiceCall deleteBindings = this.bindingsAsyncEndpoint.createServiceCall().http().delete().withoutPayload().pathParameter(new String[]{bindingId}).query(query).enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end();
            logger.debug("Call service manager to delete binding {}", (Object)bindingId);
            ServiceResponse response = deleteBindings.execute(Map.class);
            Optional<Header> locationHeader = Arrays.stream(response.getHeaders()).filter(h -> LOCATION.equalsIgnoreCase(h.getName())).findFirst();
            if (!locationHeader.isPresent()) {
                throw new InternalError("No location header returned for asynchronous delete binding operation");
            }
            String locationUrl = locationHeader.get().getValue();
            return this.waitForCompletionAndGetId(locationUrl, this.serviceSpecification.getPolling());
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    private List<ServiceInstance> readInstances(String tenantId, String instanceId) throws InternalError {
        ArrayList<ServiceInstance> result = new ArrayList<ServiceInstance>();
        this.readInstancesMaps(tenantId, instanceId).stream().forEach(map -> result.add(new ServiceInstance((Map<String, ?>)map)));
        return result;
    }

    private List<Map<String, Object>> readInstancesMaps(String tenantId, String instanceId) throws InternalError {
        return this.readInstancesMapsInt(tenantId, instanceId, null);
    }

    private Optional<String> extractPageToken(ServiceResponse<Map> response) {
        if (this.isV2) {
            for (Header header : response.getHeaders()) {
                if (!"link".equals(header.getName())) continue;
                return ServiceManager.extractPageToken(header.getValue());
            }
            return Optional.empty();
        }
        return response.getPayload().map(p -> (String)p.get(TOKEN));
    }

    @VisibleForTesting
    protected static Optional<String> extractPageToken(String link) {
        if (StringUtils.isEmpty((CharSequence)link)) {
            return Optional.empty();
        }
        int indexOfLinkStart = link.indexOf("<");
        int indexOfLinkEnd = link.indexOf(">");
        if (indexOfLinkStart == -1 || indexOfLinkEnd == -1) {
            return Optional.empty();
        }
        String url = link.substring(indexOfLinkStart + 1, indexOfLinkEnd);
        String[] parts = url.split("\\?");
        if (parts.length == 2) {
            String[] parameters;
            for (String parameter : parameters = parts[1].split("&")) {
                String[] keyVal = parameter.split("=");
                if (keyVal.length != 2 || !keyVal[0].equals("page_token")) continue;
                return Optional.of(keyVal[1]);
            }
        }
        return Optional.empty();
    }

    private List<QueryParameter> queryParametersForServiceInstances(String tenantId, String pageToken) throws InternalError {
        ArrayList<QueryParameter> parameters = new ArrayList<QueryParameter>();
        if (this.isV2) {
            if (pageToken != null) {
                parameters.add(new QueryParameter("page_token", pageToken));
            }
            parameters.add(new QueryParameter(SERVICE_PLAN_ID, this.getPlanId()));
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                parameters.add(new QueryParameter("labels", "tenant_id=%s".formatted(tenantId)));
            }
        } else {
            if (pageToken != null) {
                parameters.add(new QueryParameter(TOKEN, pageToken));
            }
            parameters.add(new QueryParameter(FIELD_QUERY, "service_plan_id eq '%s'".formatted(this.getPlanId())));
            parameters.add(new QueryParameter(ATTACH_LAST_OPERATIONS, "true"));
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                parameters.add(new QueryParameter(LABEL_QUERY, "tenant_id eq '%s'".formatted(tenantId)));
            }
        }
        return parameters;
    }

    private List<QueryParameter> queryParametersForServiceBindings(String tenantId, String instanceId, String pageToken) throws InternalError {
        ArrayList<QueryParameter> parameters = new ArrayList<QueryParameter>();
        if (this.isV2) {
            if (pageToken != null) {
                parameters.add(new QueryParameter("page_token", pageToken));
            }
            if (StringUtils.isNotBlank((CharSequence)instanceId)) {
                parameters.add(new QueryParameter("service_instance_id", instanceId));
            }
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                parameters.add(new QueryParameter("labels", "tenant_id=%s".formatted(tenantId)));
            } else {
                parameters.add(new QueryParameter("labels", "service_plan_id=%s,managing_client_lib=instance-manager-client-lib".formatted(this.getPlanId())));
            }
        } else {
            if (pageToken != null) {
                parameters.add(new QueryParameter(TOKEN, pageToken));
            }
            if (StringUtils.isNotBlank((CharSequence)instanceId)) {
                parameters.add(new QueryParameter(FIELD_QUERY, "service_instance_id eq '%s'".formatted(instanceId)));
            }
            parameters.add(new QueryParameter(ATTACH_LAST_OPERATIONS, "true"));
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                parameters.add(new QueryParameter(LABEL_QUERY, "service_plan_id eq '%s' and managing_client_lib eq 'instance-manager-client-lib' and tenant_id eq '%s'".formatted(this.getPlanId(), tenantId)));
            } else {
                parameters.add(new QueryParameter(LABEL_QUERY, "service_plan_id eq '%s' and managing_client_lib eq 'instance-manager-client-lib'".formatted(this.getPlanId())));
            }
        }
        return parameters;
    }

    private List<Map<String, Object>> readInstancesMapsInt(String tenantId, String instanceId, String pageToken) throws InternalError {
        List<QueryParameter> queryParameters = this.queryParametersForServiceInstances(tenantId, pageToken);
        try {
            ServiceResponse<Map> response = this.requestServiceInstances(tenantId, instanceId, queryParameters);
            if (StringUtils.isNotBlank((CharSequence)instanceId)) {
                if (response.getHttpStatusCode() == 404 || response.getPayload().isEmpty()) {
                    return new ArrayList<Map<String, Object>>();
                }
                return List.of((Map)response.getPayload().orElse(new HashMap()));
            }
            List<Map<String, Object>> instances = this.getItems(response.getPayload().orElse(new HashMap()));
            Optional<String> nextPageToken = this.extractPageToken(response);
            if (nextPageToken.isPresent()) {
                instances.addAll(this.readInstancesMapsInt(tenantId, null, nextPageToken.get()));
            }
            return instances;
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    private ServiceResponse<Map> requestServiceInstances(String tenantId, String instanceId, List<QueryParameter> parameters) throws InternalException, ServiceException {
        ServiceCall getInstances;
        ServiceEndpoint manyInstances;
        ServiceEndpoint oneInstance = this.isV2 ? this.oneInstanceEndpointV2 : this.oneInstanceEndpoint;
        ServiceEndpoint serviceEndpoint = manyInstances = this.isV2 ? this.instancesEndpointV2 : this.instancesEndpoint;
        if (StringUtils.isNotBlank((CharSequence)instanceId)) {
            getInstances = oneInstance.createServiceCall().http().get().withoutPayload().pathParameter(new String[]{instanceId}).query(Collections.emptyList()).enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end();
            logger.debug("Call service manager to determine service instance with instance id {}", (Object)instanceId);
        } else {
            getInstances = manyInstances.createServiceCall().http().get().withoutPayload().noPathParameter().query(parameters).enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end();
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                logger.debug("Call service manager to determine service instances with tenant id {}", (Object)tenantId);
            } else {
                logger.debug("Call service manager to determine all service instances");
            }
        }
        return getInstances.execute(Map.class);
    }

    private ServiceResponse<Map> requestServiceBindings(String tenantId, String instanceId, String bindingId, List<QueryParameter> parameters) throws InternalException, ServiceException {
        ServiceEndpoint oneBinding = this.isV2 ? this.oneBindingEndpointV2 : this.oneBindingEndpoint;
        ServiceEndpoint manyBindings = this.isV2 ? this.bindingsEndpointV2 : this.bindingsEndpoint;
        ServiceCall getBindings = StringUtils.isNotBlank((CharSequence)bindingId) ? oneBinding.createServiceCall().http().get().withoutPayload().pathParameter(new String[]{bindingId}).query(Collections.emptyList()).enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end() : manyBindings.createServiceCall().http().get().withoutPayload().noPathParameter().query(parameters).enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end();
        logger.debug("Call service manager to determine service bindings for tenant id {} instance id {} binding id {}", new Object[]{tenantId, instanceId, bindingId});
        return getBindings.execute(Map.class);
    }

    private List<ServiceBinding> readBindings(String tenantId, String instanceId, String bindingId) throws InternalError {
        ArrayList<ServiceBinding> bindings = new ArrayList<ServiceBinding>();
        this.readBindingsMaps(tenantId, instanceId, bindingId).forEach(map -> bindings.add(new ServiceBinding((Map<String, ?>)map)));
        return bindings;
    }

    private List<Map<String, Object>> readBindingsMaps(String tenantId, String instanceId, String bindingId) throws InternalError {
        return this.readBindingsMapsInt(tenantId, instanceId, bindingId, null);
    }

    private List<Map<String, Object>> readBindingsMapsInt(String tenantId, String instanceId, String bindingId, String pageToken) throws InternalError {
        try {
            List<QueryParameter> parameters = this.queryParametersForServiceBindings(tenantId, instanceId, pageToken);
            ServiceResponse<Map> response = this.requestServiceBindings(tenantId, instanceId, bindingId, parameters);
            if (StringUtils.isNotBlank((CharSequence)bindingId)) {
                if (response.getHttpStatusCode() == 404 || response.getPayload().isEmpty()) {
                    return new ArrayList<Map<String, Object>>();
                }
                return List.of((Map)response.getPayload().orElse(new HashMap()));
            }
            List<Map<String, Object>> bindings = this.getItems(response.getPayload().orElse(new HashMap()));
            Optional<String> nextPageToken = this.extractPageToken(response);
            if (nextPageToken.isPresent()) {
                bindings.addAll(this.readBindingsMapsInt(tenantId, instanceId, null, nextPageToken.get()));
            }
            return bindings;
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    private String readOfferingId(String offeringName) throws InternalError {
        String offeringId;
        ServiceEndpoint endpoint = this.isV2 ? this.offeringsEndpointV2 : this.offeringsEndpoint;
        List<QueryParameter> parameters = this.isV2 ? List.of(new QueryParameter("name", offeringName)) : List.of(new QueryParameter(FIELD_QUERY, "catalog_name eq '%s'".formatted(offeringName)));
        try {
            ServiceCall getOfferings = endpoint.createServiceCall().http().get().withoutPayload().noPathParameter().query(parameters).enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end();
            logger.debug("Call service manager to determine service offerings for {}", (Object)offeringName);
            ServiceResponse response = getOfferings.execute(Map.class);
            offeringId = this.getIdFromItems((ServiceResponse<Map>)response, "No service offering found for %s ".formatted(offeringName), "Multiple offerings found for %s".formatted(offeringName), "No service offering id is contained in payload");
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
        if (StringUtils.isBlank((CharSequence)offeringId)) {
            throw new InternalError("Could not determine offering id for %s".formatted(offeringName));
        }
        return offeringId;
    }

    private String readPlanId(String serviceOfferingId) throws InternalError {
        String planId = "";
        ServiceEndpoint endpoint = this.isV2 ? this.plansEndpointV2 : this.plansEndpoint;
        List<QueryParameter> parameters = this.isV2 ? List.of(new QueryParameter("name", this.planName), new QueryParameter("service_offering_id", serviceOfferingId)) : List.of(new QueryParameter(FIELD_QUERY, "catalog_name eq '%s' and service_offering_id eq '%s'".formatted(this.planName, serviceOfferingId)));
        try {
            ServiceCall getPlans = endpoint.createServiceCall().http().get().withoutPayload().noPathParameter().query(parameters).enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end();
            logger.debug("Call service manager to determine plan id for {}", (Object)this.planName);
            ServiceResponse response = getPlans.execute(Map.class);
            planId = this.getIdFromItems((ServiceResponse<Map>)response, "No service plan found for %s".formatted(this.planName), "Multiple plans found for %s".formatted(this.planName), "No service plan id is contained in payload");
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
        if (StringUtils.isBlank((CharSequence)planId)) {
            throw new InternalError("Could not determine plan id for %s".formatted(this.planName));
        }
        return planId;
    }

    private String getIdFromItems(ServiceResponse<Map> response, String noItemsText, String toManyItemsText, String noIdText) throws InternalError {
        List<Map<String, Object>> items = this.getItems(response.getPayload().orElse(new HashMap()));
        if (items.isEmpty()) {
            throw new InternalError(noItemsText);
        }
        if (items.size() > 1) {
            throw new InternalError(toManyItemsText);
        }
        Map<String, Object> item = items.get(0);
        if (item.get(ID) == null) {
            throw new InternalError(noIdText);
        }
        return (String)item.get(ID);
    }

    private List<Map<String, Object>> getItems(Map<String, Object> payload) {
        if (payload.containsKey(ITEMS)) {
            return (List)payload.get(ITEMS);
        }
        return new ArrayList<Map<String, Object>>();
    }

    private String getPlanId() throws InternalError {
        try {
            return this.planIdMap.computeIfAbsent(this.serviceOfferingName, key -> {
                try {
                    String offeringId = this.readOfferingId(this.serviceOfferingName);
                    return this.readPlanId(offeringId);
                }
                catch (InternalError error) {
                    throw new DeterminationError("Could not determine offering id", error);
                }
            });
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
    }

    private String waitForCompletionAndGetId(String path, PollingParameters pollingParameter) throws InternalError {
        Instant start = Instant.now();
        while (true) {
            logger.debug("Wait for completion of operation {}", (Object)path);
            ServiceOperation result = this.getOperationResult(path);
            if (result.isReady() && !IN_PROGRESS.equals(result.getState())) {
                String state = result.getState();
                if (SUCCEEDED.equals(state)) {
                    if (StringUtils.isBlank((CharSequence)result.getResourceId())) {
                        throw new InternalError("No id returned");
                    }
                    return result.getResourceId();
                }
                String errorJson = "";
                if (result.getErrors() != null) {
                    try {
                        errorJson = this.mapper.writeValueAsString(result.getErrors());
                    }
                    catch (JsonProcessingException e) {
                        errorJson = "";
                    }
                }
                throw new InternalError("Operation failed with state %s and error %s".formatted(state, errorJson));
            }
            if (Duration.between(start, Instant.now()).compareTo(pollingParameter.getRequestTimeout()) >= 0) {
                throw new InternalError("Maximum waiting time on operation %s exceeded".formatted(path));
            }
            Tools.waitSomeTime(pollingParameter.getInterval());
        }
    }

    private ServiceOperation getOperationResult(String path) throws InternalError {
        try {
            ServiceCall getOperationResult = this.locationEndpoint.createServiceCall().http().get().withoutPayload().pathParameter(new String[]{path}).noQuery().enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(CALLED_FROM).end();
            logger.debug("Call service manager to determine operation status for {}", (Object)path);
            ServiceResponse response = getOperationResult.execute(Map.class);
            return new ServiceOperation(response.getPayload().orElse(new HashMap()));
        }
        catch (InternalException | ServiceException e) {
            throw this.serviceErrorHandling((Exception)e);
        }
    }

    private ServiceEndpoint createEndpoint(HttpDestination destination, String path, Set<Integer> expectedResponseCodes, Set<Integer> retryCodes) throws InternalException {
        return ServiceEndpoint.create().destination(destination).path(path).returnCodeChecker(c -> {
            if (!expectedResponseCodes.contains(c)) {
                return new InternalError(UNEXPECTED_RETURN_CODE.formatted(c));
            }
            return null;
        }).retry().forReturnCodes(retryCodes).config(this.serviceSpecification.getResilienceConfig()).end();
    }

    private InternalError serviceErrorHandling(Exception e) {
        Throwable throwable = e.getCause();
        if (throwable instanceof InternalError) {
            InternalError internalError = (InternalError)throwable;
            return internalError;
        }
        return new InternalError(e);
    }

    private Optional<ServiceInstance> extractServiceInstance(List<Map<String, Object>> instances, String tooManyErrorText) throws InternalError {
        Map<String, Object> instanceData = this.extractSingleItem(instances, tooManyErrorText);
        return !instanceData.isEmpty() ? Optional.of(new ServiceInstance(instanceData)) : Optional.empty();
    }

    private Optional<ServiceInstance> extractFirstInstance(List<Map<String, Object>> instances) {
        Map<String, Object> instanceData = this.extractFirstItem(instances);
        return !instanceData.isEmpty() ? Optional.of(new ServiceInstance(instanceData)) : Optional.empty();
    }

    private Optional<ServiceBinding> extractServiceBinding(List<Map<String, Object>> bindings, String tooManyErrorText) throws InternalError {
        Map<String, Object> bindingData = this.extractSingleItem(bindings, tooManyErrorText);
        return !bindingData.isEmpty() ? Optional.of(new ServiceBinding(bindingData)) : Optional.empty();
    }

    private Map<String, Object> extractSingleItem(List<Map<String, Object>> instances, String tooManyErrorText) throws InternalError {
        if (instances.isEmpty()) {
            return new HashMap<String, Object>();
        }
        if (instances.size() > 1) {
            throw new InternalError(tooManyErrorText);
        }
        return instances.get(0);
    }

    private Map<String, Object> extractFirstItem(List<Map<String, Object>> instances) {
        if (instances.isEmpty()) {
            return new HashMap<String, Object>();
        }
        return instances.get(0);
    }

    private String calculateServiceInstanceName(String tenantId) throws InternalError {
        byte[] hash = DigestUtils.sha256((String)(this.getPlanId() + "_" + tenantId));
        return Base64.encodeBase64String((byte[])hash);
    }

    private static HttpDestination getDestination(com.sap.cloud.environment.servicebinding.api.ServiceBinding binding, Duration oauthTimeout) throws InternalError {
        if (StringUtils.isBlank((CharSequence)((String)binding.getCredentials().get(SM_URL)))) {
            throw new InternalError("Service manager url is missing");
        }
        if (binding.getName().isEmpty() || StringUtils.isBlank((CharSequence)((CharSequence)binding.getName().get()))) {
            throw new InternalError("Service binding name is missing");
        }
        if (binding.getServiceName().isEmpty() || StringUtils.isBlank((CharSequence)((CharSequence)binding.getServiceName().get()))) {
            throw new InternalError("Service name is missing");
        }
        ResilienceConfiguration.TimeLimiterConfiguration timeLimiterConfiguration = ResilienceConfiguration.TimeLimiterConfiguration.of((Duration)(oauthTimeout != null ? oauthTimeout : Duration.ofSeconds(30L)));
        return ServiceBindingDestinationLoader.defaultLoaderChain().getDestination(ServiceBindingDestinationOptions.forService((com.sap.cloud.environment.servicebinding.api.ServiceBinding)binding).withOption((ServiceBindingDestinationOptions.OptionsEnhancer)OAuth2Options.TokenRetrievalTimeout.of((ResilienceConfiguration.TimeLimiterConfiguration)timeLimiterConfiguration)).onBehalfOf(OnBehalfOf.TECHNICAL_USER_PROVIDER).build());
    }

    static {
        ServiceManagerPropertySupplier.initialize();
        CALLED_FROM = Map.of("Client-Name", "cap-java-client", "Client-Version", "3.0.0");
        logger = LoggerFactory.getLogger(ServiceManager.class);
    }

    private record CreateInstancePayload(String service_plan_id, String name, Map<String, Object> parameters, Map<String, List<String>> labels) {
    }

    private record CreateBindingPayload(String service_instance_id, String name, Map<String, Object> parameters, Map<String, List<String>> labels) {
    }

    private static class DeterminationError
    extends RuntimeException {
        public DeterminationError(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class ServiceManagerPropertySupplier
    extends DefaultOAuth2PropertySupplier {
        public static final String SERVICE_MANAGER = "service-manager";
        private static boolean initialized = false;

        public static synchronized void initialize() {
            if (!initialized) {
                OAuth2ServiceBindingDestinationLoader.registerPropertySupplier(ServiceManagerPropertySupplier::matches, ServiceManagerPropertySupplier::new);
                initialized = true;
            }
        }

        public ServiceManagerPropertySupplier(ServiceBindingDestinationOptions options) {
            super(options, Collections.emptyList());
        }

        public URI getServiceUri() {
            return (URI)this.getOAuthCredentialOrThrow(URI.class, new String[]{ServiceManager.SM_URL});
        }

        public URI getTokenUri() {
            return (URI)this.getOAuthCredential(URI.class, new String[]{"certurl"}).getOrElse((Object)((URI)this.getOAuthCredentialOrThrow(URI.class, new String[]{"url"})));
        }

        public ClientIdentity getClientIdentity() {
            return this.getOAuthCredential(String.class, new String[]{"certurl"}).isDefined() ? this.getCertificateIdentity() : this.getSecretIdentity();
        }

        ClientIdentity getCertificateIdentity() {
            String clientid = (String)this.getOAuthCredentialOrThrow(String.class, new String[]{"clientid"});
            String cert = (String)this.getOAuthCredentialOrThrow(String.class, new String[]{"certificate"});
            String key = (String)this.getOAuthCredentialOrThrow(String.class, new String[]{"key"});
            return new ClientCertificate(cert, key, clientid);
        }

        ClientIdentity getSecretIdentity() {
            String clientid = (String)this.getOAuthCredentialOrThrow(String.class, new String[]{"clientid"});
            String secret = (String)this.getOAuthCredentialOrThrow(String.class, new String[]{"clientsecret"});
            return new ClientCredentials(clientid, secret);
        }

        private static boolean matches(ServiceBindingDestinationOptions options) {
            return ServiceBindingUtils.matches((com.sap.cloud.environment.servicebinding.api.ServiceBinding)options.getServiceBinding(), (String)SERVICE_MANAGER, (String)SERVICE_MANAGER);
        }
    }

    @FunctionalInterface
    public static interface SmCaller<T> {
        public ServiceResponse<T> call() throws ServiceException;
    }
}

