/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.sms;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.adapter.sms.CertValidator;
import com.sap.cds.feature.mt.ExecutorUtils;
import com.sap.cds.feature.mt.SmsClient;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.mt.DeploymentService;
import com.sap.cds.services.mt.SmsCallback;
import com.sap.cds.services.mt.SmsSubscriptionRequest;
import com.sap.cds.services.mt.SmsUnsubscriptionRequest;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.mt.subscription.UiUrlCreator;
import com.sap.cloud.mt.subscription.exceptions.InternalError;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsProvisioningServlet
extends HttpServlet {
    private final ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(SmsProvisioningServlet.class);
    private static final String DEPENDENCIES = "/dependencies";
    private static final String TENANTS = "/tenants/";
    private static final String FALLBACK_APP_URL = "tenant successfully subscribed - no application URL provided";
    private static final String HEADER_STATUS_CALLBACK = "STATUS_CALLBACK";
    private final CdsRuntime runtime;
    private final DeploymentService deploymentService;
    private final SmsClient sms;
    private final CertValidator certValidator;

    public SmsProvisioningServlet(CdsRuntime runtime) {
        this.runtime = runtime;
        this.deploymentService = (DeploymentService)runtime.getServiceCatalog().getService(DeploymentService.class, "DeploymentService$Default");
        ServiceBinding smsBinding = SmsClient.findBinding(runtime).orElse(null);
        this.sms = smsBinding != null ? new SmsClient(smsBinding) : null;
        this.certValidator = smsBinding != null ? CertValidator.create(runtime, smsBinding) : null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        this.processRequest(req, res, p -> p.endsWith(DEPENDENCIES), () -> {
            List dependencies = this.deploymentService.dependencies();
            SmsProvisioningServlet.setContentType(res, ContentType.APPLICATION_JSON);
            res.setStatus(200);
            res.getWriter().write(this.mapper.writeValueAsString((Object)dependencies));
        });
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) {
        this.processRequest(req, res, p -> p.startsWith(TENANTS), () -> {
            String tenantId = SmsProvisioningServlet.getTenantId(req);
            logger.info("Subscribing IAS tenant '{}'", (Object)tenantId);
            SmsSubscriptionRequest subReq = SmsSubscriptionRequest.create(this.toMap((InputStream)req.getInputStream()));
            String callbackUrl = req.getHeader(HEADER_STATUS_CALLBACK);
            String appUiUrl = this.getAppUiUrl(subReq);
            if (callbackUrl != null) {
                if (this.sms == null) {
                    logger.error("Asynchronous callbacks to Subscription Manager Service require a subscription-manager binding.");
                    throw new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[0]);
                }
                logger.debug("Processing subscription for IAS tenant '{}' asynchronously", (Object)tenantId);
                ExecutorUtils.runAsynchronously(this.runtime, () -> {
                    boolean success = false;
                    try {
                        this.deploymentService.subscribe(tenantId, (Map)((Object)subReq));
                        success = true;
                        logger.info("Subscription for IAS tenant '{}' finished successfully", (Object)tenantId);
                    }
                    catch (Throwable e) {
                        logger.error("Subscription for IAS tenant '{}' failed", (Object)tenantId, (Object)e);
                    }
                    try {
                        SmsCallback callback = SmsCallback.create();
                        callback.setApplicationUrl(appUiUrl);
                        if (success) {
                            callback.setStatus("SUCCEEDED");
                            callback.setMessage("Subscription succeeded");
                        } else {
                            callback.setStatus("FAILED");
                            callback.setMessage("Subscription failed");
                        }
                        this.sms.putRequest(callbackUrl, (JsonNode)this.mapper.convertValue((Object)callback, JsonNode.class));
                    }
                    catch (Throwable e) {
                        logger.error("Failed to report status for IAS tenant '{}' to Subscription Manager Service", (Object)tenantId, (Object)e);
                    }
                });
                res.setStatus(202);
            } else {
                logger.debug("Processing subscription for IAS tenant '{}' synchronously", (Object)tenantId);
                this.deploymentService.subscribe(tenantId, (Map)((Object)subReq));
                res.setStatus(200);
                SmsProvisioningServlet.setContentType(res, ContentType.TEXT_PLAIN);
                HashMap<String, String> response = new HashMap<String, String>();
                response.put("applicationURL", appUiUrl);
                res.getWriter().write(this.mapper.writeValueAsString(response));
            }
        });
    }

    private Map<String, Object> parseQueryString(HttpServletRequest req) {
        String[] parameters;
        HashMap<String, Object> parsed = new HashMap<String, Object>();
        String queryString = req.getQueryString();
        if (queryString == null) {
            return parsed;
        }
        for (String parameter : parameters = queryString.split("&")) {
            String[] keyVal = parameter.split("=");
            if (keyVal.length != 2) continue;
            String key = keyVal[0];
            String val = keyVal[1];
            if (val == null) continue;
            parsed.put(key, val);
        }
        return parsed;
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse res) {
        this.processRequest(req, res, p -> p.startsWith(TENANTS), () -> {
            String tenantId = SmsProvisioningServlet.getTenantId(req);
            logger.info("Unsubscribing IAS tenant '{}'", (Object)tenantId);
            Map<String, Object> payload = this.parseQueryString(req);
            SmsUnsubscriptionRequest deleteSubRequest = SmsUnsubscriptionRequest.create(payload);
            String callbackUrl = req.getHeader(HEADER_STATUS_CALLBACK);
            if (callbackUrl != null) {
                if (this.sms == null) {
                    logger.error("Asynchronous callbacks to SMS require an SMS binding.");
                    throw new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[0]);
                }
                logger.debug("Processing unsubscription for tenant '{}' asynchronously", (Object)tenantId);
                ExecutorUtils.runAsynchronously(this.runtime, () -> {
                    boolean success = false;
                    try {
                        this.deploymentService.unsubscribe(tenantId, (Map)((Object)deleteSubRequest));
                        success = true;
                        logger.info("Unsubscription for tenant '{}' finished successfully", (Object)tenantId);
                    }
                    catch (Throwable e) {
                        logger.error("Unsubscription for tenant '{}' failed", (Object)tenantId, (Object)e);
                    }
                    try {
                        SmsCallback callback = SmsCallback.create();
                        if (success) {
                            callback.setStatus("SUCCEEDED");
                            callback.setMessage("Removing subscription succeeded");
                        } else {
                            callback.setStatus("FAILED");
                            callback.setMessage("Removing subscription failed");
                        }
                        this.sms.putRequest(callbackUrl, (JsonNode)this.mapper.convertValue((Object)callback, JsonNode.class));
                    }
                    catch (Throwable e) {
                        logger.error("Failed to report status for tenant '{}' to Subscription Manager Service", (Object)tenantId, (Object)e);
                    }
                });
                res.setStatus(202);
            } else {
                logger.debug("Processing unsubscription for tenant '{}' synchronously", (Object)tenantId);
                this.deploymentService.unsubscribe(tenantId, (Map)((Object)deleteSubRequest));
                res.setStatus(200);
            }
        });
    }

    private void checkAuthorization() {
        RequestContext requestContext = RequestContext.getCurrent((CdsRuntime)this.runtime);
        if (requestContext.getUserInfo().isPrivileged() || requestContext.getUserInfo().isInternalUser()) {
            return;
        }
        this.certValidator.validateCertFromRequestContext(requestContext);
    }

    private static String getTenantId(HttpServletRequest req) {
        String tenantId = req.getPathInfo().split("/")[2];
        if (StringUtils.isEmpty((String)tenantId)) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[0]);
        }
        return tenantId;
    }

    private static void setContentType(HttpServletResponse resp, ContentType contType) {
        resp.setContentType(contType.getMimeType());
        resp.setCharacterEncoding(contType.getCharset().toString());
    }

    private Map<String, Object> toMap(InputStream stream) {
        try {
            TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
            return (Map)this.mapper.readValue(stream, (TypeReference)typeRef);
        }
        catch (Exception e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.BAD_REQUEST, new Object[]{e});
        }
    }

    private String getAppUiUrl(SmsSubscriptionRequest req) {
        try {
            CdsProperties.MultiTenancy.AppUi appUi = this.runtime.getEnvironment().getCdsProperties().getMultiTenancy().getAppUi();
            String configuredUrl = UiUrlCreator.createUrl((String)req.getSubscriber().getSubaccountSubdomain(), (String)appUi.getUrl(), (String)appUi.getTenantSeparator());
            return StringUtils.isEmpty((String)configuredUrl) ? FALLBACK_APP_URL : configuredUrl;
        }
        catch (InternalError e) {
            logger.error("Failed to create app UI URL.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static void handleException(HttpServletResponse res, Locale locale, ServiceException e) {
        block10: {
            if (e.getErrorStatus().getHttpStatus() >= 500 && e.getErrorStatus().getHttpStatus() < 600) {
                logger.error("Unexpected error", (Throwable)e);
            } else {
                logger.debug("Service exception thrown", (Throwable)e);
            }
            res.setStatus(e.getErrorStatus().getHttpStatus());
            try {
                String message = e.getLocalizedMessage(locale);
                if (message == null) break block10;
                try (PrintWriter writer = res.getWriter();){
                    writer.write(message);
                }
            }
            catch (IOException e1) {
                logger.error("Failed to write error message to response", (Throwable)e1);
            }
        }
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse res, Predicate<String> pathMatcher, Processor processor) {
        if (pathMatcher.test(req.getPathInfo())) {
            try {
                this.checkAuthorization();
            }
            catch (ServiceException e) {
                SmsProvisioningServlet.handleException(res, null, e);
                return;
            }
            catch (Throwable t) {
                logger.error("Unexpected error", t);
                res.setStatus(500);
                return;
            }
            this.runtime.requestContext().systemUserProvider().privilegedUser().run(requestContext -> {
                try {
                    processor.process();
                }
                catch (ServiceException e) {
                    SmsProvisioningServlet.handleException(res, requestContext.getParameterInfo().getLocale(), e);
                }
                catch (Throwable t) {
                    logger.error("Unexpected error", t);
                    res.setStatus(500);
                }
            });
        } else {
            res.setStatus(404);
        }
    }

    @FunctionalInterface
    private static interface Processor {
        public void process() throws IOException;
    }
}

