/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.feature.mt.lib.subscription.DbCredentials;
import com.sap.cds.feature.mt.lib.subscription.DbCredentialsBuilder;
import com.sap.cds.feature.mt.lib.subscription.DbIdentifiersSqLite;
import com.sap.cds.feature.mt.lib.subscription.DbIdentifiersSql;
import com.sap.cds.feature.mt.lib.subscription.InstanceLifecycleManager;
import com.sap.cds.feature.mt.lib.subscription.InstanceLifecycleManagerBuilder;
import com.sap.cds.feature.mt.lib.subscription.PollingParameters;
import com.sap.cds.feature.mt.lib.subscription.ServiceManager;
import com.sap.cds.feature.mt.lib.subscription.ServiceSpecification;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.environment.ServiceBindingUtils;
import com.sap.cds.services.utils.model.DynamicModelUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MtUtils {
    private static final String HANA_OFFERING_NAME = "hana";
    private static final String HANA_HDI_PLAN_NAME = "hdi-shared";
    static final String SERVICE_MANAGER = "service-manager";
    static final String MT_ENABLED = "mt-enabled";
    static final String SQLITE_BINDING_NAME = "mtx-sqlite";
    public static final String CONTAINER = "container";
    private final DynamicModelUtils dynamicModelUtils;
    private final CdsProperties.MultiTenancy config;
    private final List<ServiceBinding> bindings;
    private final ServiceBinding defaultBinding;

    public MtUtils(CdsRuntime runtime) {
        this.dynamicModelUtils = new DynamicModelUtils(runtime);
        this.config = runtime.getEnvironment().getCdsProperties().getMultiTenancy();
        this.bindings = runtime.getEnvironment().getServiceBindings().filter(b -> this.isServiceManagerBinding((ServiceBinding)b) || this.isSchemaBasedMtBinding((ServiceBinding)b)).toList();
        String bindingName = runtime.getEnvironment().getCdsProperties().getDataSource().getBinding();
        if (StringUtils.isEmpty((String)bindingName)) {
            if (this.bindings.size() == 1) {
                this.defaultBinding = this.bindings.get(0);
            } else {
                if (this.bindings.size() > 1) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.NO_UNIQUE_DATASOURCE_SERVICE, new Object[0]);
                }
                this.defaultBinding = null;
            }
        } else {
            this.defaultBinding = this.bindings.stream().filter(b -> ((String)b.getName().get()).equals(bindingName)).findFirst().orElse(null);
        }
    }

    public boolean requiresSubscription() {
        boolean deployerConfigured = this.hasDeployer();
        return this.defaultBinding != null && (deployerConfigured || this.isSchemaBasedMtBinding(this.defaultBinding)) || this.isSqliteDataSourceEnabled() && deployerConfigured;
    }

    private boolean hasDeployer() {
        boolean dynamicDeployer = !StringUtils.isEmpty((String)this.config.getDeployer().getUrl());
        boolean provisioningService = this.isProvisioningServiceEnabled();
        if (dynamicDeployer && provisioningService) {
            throw new IllegalArgumentException("Either Sidecar/ProvisioningService or Deployer URL can be specified");
        }
        return dynamicDeployer || provisioningService;
    }

    public boolean isProvisioningServiceEnabled() {
        return !StringUtils.isEmpty((String)this.getProvisioningServiceUrl());
    }

    public String getProvisioningServiceUrl() {
        return !StringUtils.isEmpty((String)this.config.getProvisioning().getUrl()) ? this.config.getProvisioning().getUrl() : this.config.getSidecar().getUrl();
    }

    public InstanceLifecycleManager createDefaultInstanceLifecycleManager() {
        if (this.defaultBinding != null) {
            return this.createInstanceLifecycleManager(this.defaultBinding);
        }
        if (this.isSqliteDataSourceEnabled()) {
            return this.createInstanceLifecycleManagerSqlite();
        }
        return null;
    }

    public Map<String, InstanceLifecycleManager> createInstanceLifecycleManagers() {
        HashMap<String, InstanceLifecycleManager> ilms = new HashMap<String, InstanceLifecycleManager>();
        for (ServiceBinding binding : this.bindings) {
            ilms.put((String)binding.getName().get(), this.createInstanceLifecycleManager(binding));
        }
        if (this.isSqliteDataSourceEnabled()) {
            ilms.put(SQLITE_BINDING_NAME, this.createInstanceLifecycleManagerSqlite());
        }
        return ilms;
    }

    private boolean isSqliteDataSourceEnabled() {
        return this.bindings.isEmpty() && !Boolean.FALSE.equals(this.config.getMock().isEnabled()) && (this.isProvisioningServiceEnabled() || Boolean.TRUE.equals(this.config.getMock().isEnabled()));
    }

    private boolean isServiceManagerBinding(ServiceBinding b) {
        return ServiceBindingUtils.matches((ServiceBinding)b, (String)SERVICE_MANAGER) && b.getServicePlan().orElse("").equals(CONTAINER);
    }

    private boolean isSchemaBasedMtBinding(ServiceBinding b) {
        return ServiceBindingUtils.matches((ServiceBinding)b, (String)MT_ENABLED, null);
    }

    private InstanceLifecycleManager createInstanceLifecycleManagerSqlite() {
        InstanceLifecycleManagerBuilder builder = InstanceLifecycleManagerBuilder.create();
        String sqliteDirectory = this.config.getMock().getSqliteDirectory();
        if (!StringUtils.isEmpty((String)sqliteDirectory)) {
            builder.dbIdentifiers(new DbIdentifiersSqLite(Paths.get(sqliteDirectory, new String[0])));
        } else {
            builder.dbIdentifiers(new DbIdentifiersSqLite(Paths.get(System.getProperty("user.dir"), new String[0])));
        }
        try {
            return builder.build();
        }
        catch (InternalError internalError) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MT_LIB_SETUP_FAILED, new Object[]{internalError.getMessage(), internalError});
        }
    }

    private InstanceLifecycleManager createInstanceLifecycleManager(ServiceBinding binding) {
        InstanceLifecycleManager newIlm;
        InstanceLifecycleManagerBuilder builder = InstanceLifecycleManagerBuilder.create();
        if (this.isServiceManagerBinding(binding)) {
            builder.serviceManager(this.createServiceManager(binding));
            builder.smCacheRefreshInterval(this.config.getServiceManager().getCacheRefreshInterval());
            builder.acceptInstancesWithoutTenant(this.config.getServiceManager().getAcceptInstancesWithoutTenant().isEnabled());
            builder.smCacheResilienceConfig(this.dynamicModelUtils.getResilienceConfig());
            try {
                newIlm = builder.build();
            }
            catch (InternalError internalError) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INSTANCE_MANAGER_CLIENT_FAILED, new Object[]{binding.getName().get(), internalError});
            }
        }
        try {
            DbCredentials dbCredentials = DbCredentialsBuilder.create().credentials(binding.getCredentials()).build();
            builder.dbIdentifiers(new DbIdentifiersSql(Collections.singletonList(dbCredentials)));
            newIlm = builder.build();
        }
        catch (InternalError internalError) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MT_LIB_SETUP_FAILED, new Object[]{internalError.getMessage(), internalError});
        }
        return newIlm;
    }

    @VisibleForTesting
    ServiceManager createServiceManager(ServiceBinding binding) {
        try {
            return new ServiceManager(binding, ServiceSpecification.Builder.create().polling(PollingParameters.Builder.create().interval(Duration.ofSeconds(10L)).timeout(Duration.ofMinutes(20L)).build()).resilienceConfig(this.dynamicModelUtils.getResilienceConfig()).build(), HANA_OFFERING_NAME, HANA_HDI_PLAN_NAME);
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INSTANCE_MANAGER_CLIENT_FAILED, new Object[]{binding.getName().get(), e});
        }
    }

    @VisibleForTesting
    ServiceBinding getDefaultBinding() {
        return this.defaultBinding;
    }
}

