/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.runtime;

import com.sap.cds.feature.mt.lib.runtime.ConnectionProvider;
import com.sap.cds.feature.mt.lib.runtime.DataSourceAndInfo;
import com.sap.cds.feature.mt.lib.subscription.DataSourceInfo;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HanaConnectionProvider
implements ConnectionProvider {
    private static Logger logger = LoggerFactory.getLogger(HanaConnectionProvider.class);

    @Override
    public Connection getConnection(String tenantId, DataSourceAndInfo dataSourceAndInfo) throws SQLException {
        DataSourceInfo info = dataSourceAndInfo.getDataSourceInfo();
        Connection connection = dataSourceAndInfo.getDataSource().getConnection();
        connection.setClientInfo("LOCALE", null);
        try (Statement statement = connection.createStatement();){
            logger.debug("Reconnect connection for user {}", (Object)info.getUser());
            statement.execute("connect %s password \"%s\" ".formatted(info.getUser(), info.getPassword()));
            logger.debug("Set schema to {}", (Object)info.getSchema());
            connection.setSchema(info.getSchema());
            if (!connection.getSchema().equals(info.getSchema())) {
                throw new SQLException("Could not set schema " + info.getSchema());
            }
        }
        catch (SQLException sqlException) {
            connection.close();
            throw sqlException;
        }
        return connection;
    }
}

