/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription;

import com.sap.cds.feature.mt.lib.subscription.ServiceBinding;
import com.sap.cds.feature.mt.lib.subscription.ServiceOperation;
import com.sap.cds.services.utils.lib.tools.api.Cloner;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;

public class ServiceInstance
extends HashMap<String, Object> {
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String LABELS = "labels";
    public static final String TENANT_ID = "tenant_id";
    private List<ServiceBinding> bindings = new ArrayList<ServiceBinding>();
    private ServiceBinding newestBinding = null;
    private final ServiceOperation lastOperation;

    public ServiceInstance(Map<String, ?> m) {
        super(m);
        this.lastOperation = new ServiceOperation(m != null ? m : new HashMap());
    }

    public ServiceInstance createCopy() {
        ServiceInstance serviceInstanceCopy = new ServiceInstance((Map)Cloner.clone((Object)this, Map.class));
        serviceInstanceCopy.setBindings(this.bindings);
        return serviceInstanceCopy;
    }

    public String getId() {
        return this.containsKey(ID) ? (String)this.get(ID) : "";
    }

    public boolean isReady() {
        return this.containsKey("ready") && (Boolean)this.get("ready") != false;
    }

    public String getName() {
        return this.containsKey(NAME) ? (String)this.get(NAME) : "";
    }

    public String getServicePlanId() {
        return (String)this.get("service_plan_id");
    }

    public List<String> getTenants() {
        Map labels = (Map)this.get(LABELS);
        if (labels == null) {
            return new ArrayList<String>();
        }
        List tenants = (List)labels.get(TENANT_ID);
        return tenants != null ? tenants.stream().filter(t -> !StringUtils.isBlank((CharSequence)t)).toList() : new ArrayList<String>();
    }

    public void insertTenant(String tenantId) {
        Map labels = (Map)this.computeIfAbsent(LABELS, key -> new HashMap());
        List tenants = (List)labels.computeIfAbsent(TENANT_ID, key -> new ArrayList());
        tenants.add(tenantId);
    }

    public void clearTenants() {
        Map labels = (Map)this.get(LABELS);
        if (labels == null) {
            return;
        }
        List tenants = (List)labels.get(TENANT_ID);
        if (tenants != null) {
            tenants.clear();
        }
    }

    public boolean hasTenant() {
        return !this.getTenants().isEmpty();
    }

    public Instant getCreatedAt() {
        return Instant.parse((String)this.get("created_at"));
    }

    public Instant getUpdatedAt() {
        return Instant.parse((String)this.get("updated_at"));
    }

    public String getUsable() {
        return (String)this.get("usable");
    }

    public ServiceOperation getLastOperation() {
        return this.lastOperation;
    }

    public List<ServiceBinding> getBindings() {
        return this.bindings;
    }

    public void setBindings(List<ServiceBinding> bindings) {
        this.bindings = bindings != null ? bindings : new ArrayList();
        AtomicReference<Object> newestBindingRef = new AtomicReference<Object>(null);
        this.bindings.stream().filter(b -> b.getServiceInstanceId().equals(this.getId())).filter(ServiceBinding::isUsable).forEach((? super T b) -> {
            if (newestBindingRef.get() == null || b.getCreatedAt().isAfter(((ServiceBinding)newestBindingRef.get()).getCreatedAt())) {
                newestBindingRef.set(b);
            }
        });
        this.newestBinding = newestBindingRef.get() == null ? null : (ServiceBinding)newestBindingRef.get();
    }

    public Optional<ServiceBinding> getBinding() {
        return this.newestBinding != null ? Optional.of(this.newestBinding) : Optional.empty();
    }

    public boolean isUsable() {
        ServiceOperation.Status status = this.lastOperation.getStatus();
        return this.isReady() && (this.lastOperation.getType() != ServiceOperation.Type.CREATE || status != ServiceOperation.Status.FAILED && status != ServiceOperation.Status.IN_PROGRESS);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceInstance that = (ServiceInstance)o;
        return Objects.equals(this.bindings, that.bindings) && Objects.equals(this.newestBinding, that.newestBinding) && Objects.equals(this.lastOperation, that.lastOperation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bindings, this.newestBinding, this.lastOperation);
    }
}

