/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.mt.impl;

import com.sap.cds.feature.mt.lib.subscription.InstanceLifecycleManager;
import com.sap.cds.feature.mt.lib.subscription.TenantMetadata;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.mt.ReadTenantsEventContext;
import com.sap.cds.services.mt.TenantInfo;
import com.sap.cds.services.mt.TenantProviderService;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@ServiceName(value={"TenantProviderService$Default"}, type={TenantProviderService.class})
public class MtTenantProviderHandler
implements EventHandler {
    private static final String ENRICH_TENANT = "enrich_tenant";
    private final InstanceLifecycleManager ilm;

    public MtTenantProviderHandler(InstanceLifecycleManager ilm) {
        this.ilm = ilm;
    }

    @On
    @HandlerOrder(value=10901)
    public void readTenants(ReadTenantsEventContext context) {
        try {
            context.setResult(this.ilm.getAllTenantInfos(true).values().stream().map(tenant -> this.toTenantInfo((TenantMetadata)tenant, context.getFields())).collect(Collectors.toList()));
            context.put(ENRICH_TENANT, (Object)false);
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.TENANT_READ_FAILED, new Object[]{e});
        }
    }

    @After
    public void enrichTenants(ReadTenantsEventContext context) {
        Object enrichTenant = context.get(ENRICH_TENANT);
        Set fields = context.getFields();
        if (Boolean.FALSE.equals(enrichTenant) || fields != null && !fields.isEmpty() && !fields.contains("database_id")) {
            return;
        }
        try {
            Map<String, TenantMetadata> smTenants = this.ilm.getAllTenantInfos(false);
            List tenantInfo = context.getResult();
            tenantInfo.forEach(tenant -> {
                if (smTenants.containsKey(tenant.getTenant())) {
                    MtTenantProviderHandler.addDatabaseId((TenantMetadata)smTenants.get(tenant.getTenant()), tenant);
                }
            });
        }
        catch (InternalError e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.TENANT_READ_FAILED, new Object[]{e});
        }
    }

    private static void addDatabaseId(TenantMetadata smTenant, TenantInfo tenant) {
        Map<String, Object> props = smTenant.getAdditionalProperties();
        if (props != null && props.containsKey("database_id")) {
            tenant.put((Object)"database_id", props.get("database_id"));
        }
    }

    private TenantInfo toTenantInfo(TenantMetadata tenant, Set<String> fields) {
        TenantInfo info = TenantInfo.create();
        if (fields == null || fields.isEmpty() || fields.contains("tenant")) {
            info.setTenant(tenant.getTenantId());
        }
        if (fields == null || fields.isEmpty() || fields.contains("database_id")) {
            MtTenantProviderHandler.addDatabaseId(tenant, info);
        }
        return info;
    }
}

