/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.runtime;

import com.sap.cds.feature.mt.lib.runtime.ConnectionProvider;
import com.sap.cds.feature.mt.lib.runtime.GenericConnectionProvider;
import com.sap.cds.feature.mt.lib.runtime.GenericConnectionProviderOnePoolPerTenant;
import com.sap.cds.feature.mt.lib.runtime.HanaConnectionProvider;
import com.sap.cds.feature.mt.lib.runtime.SchemalessConnectionProvider;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionProviderFunction
implements BiFunction<String, Boolean, ConnectionProvider> {
    private static final ConnectionProvider HANA_CONNECTION_PROVIDER = new HanaConnectionProvider();
    private static final ConnectionProvider GENERIC_CONNECTION_PROVIDER = new GenericConnectionProvider();
    private static final ConnectionProvider SCHEMALESS_CONNECTION_PROVIDER = new SchemalessConnectionProvider();
    private static final ConnectionProvider GENERIC_CONNECTION_PROVIDER_ONE_POOL_PER_TENANT = new GenericConnectionProviderOnePoolPerTenant();
    private static final Logger logger = LoggerFactory.getLogger(ConnectionProviderFunction.class);
    private static final String USE_GENERIC_CONNECTION_PROVIDER = "Use generic connection provider";
    private static final String USE_GENERIC_CONNECTION_PROVIDER_ONE_POOL_PER_TENANT = "Use generic connection provider one pool per tenant";

    @Override
    public ConnectionProvider apply(String driver, Boolean onDataSourcePerDb) {
        if (onDataSourcePerDb == null) {
            onDataSourcePerDb = false;
        }
        switch (driver) {
            case "com.sap.db.jdbc.Driver": {
                if (onDataSourcePerDb.booleanValue()) {
                    logger.debug("Use HANA connection provider");
                    return HANA_CONNECTION_PROVIDER;
                }
                logger.debug(USE_GENERIC_CONNECTION_PROVIDER_ONE_POOL_PER_TENANT);
                return GENERIC_CONNECTION_PROVIDER_ONE_POOL_PER_TENANT;
            }
            case "org.sqlite.JDBC": {
                return SCHEMALESS_CONNECTION_PROVIDER;
            }
        }
        logger.debug(USE_GENERIC_CONNECTION_PROVIDER);
        return GENERIC_CONNECTION_PROVIDER;
    }
}

