/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.lib.subscription;

import com.sap.cds.feature.mt.lib.subscription.ServiceSpecification;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import com.sap.cds.feature.mt.lib.subscription.json.SaasCallbackPayload;
import com.sap.cds.services.utils.lib.tools.api.ServiceEndpoint;
import com.sap.cds.services.utils.lib.tools.exception.InternalException;
import com.sap.cds.services.utils.lib.tools.exception.ServiceException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaasRegistry {
    public static final String SUCCEEDED = "SUCCEEDED";
    public static final String FAILED = "FAILED";
    public static final String SAAS_REGISTRY_DESTINATION = "com.sap.cds.saasRegistry";
    private static final String APPLICATION_JSON = "application/json";
    private static final Logger logger = LoggerFactory.getLogger(SaasRegistry.class);
    private ServiceSpecification serviceSpecification;

    public SaasRegistry(ServiceSpecification serviceSpecification) {
        this.serviceSpecification = serviceSpecification;
    }

    public void callBackSaasRegistry(boolean success, String message, String subscriptionUrl, String callbackUrl) throws InternalError {
        ServiceEndpoint saasRegistry = null;
        try {
            saasRegistry = ServiceEndpoint.create().destinationName(SAAS_REGISTRY_DESTINATION).path(callbackUrl).returnCodeChecker(c -> {
                if (c != 200) {
                    return new InternalError("Saas registry returned http status " + c);
                }
                return null;
            }).retry().forReturnCodes(new Integer[]{502, 504, 500, 503}).config(this.serviceSpecification.getResilienceConfig()).end();
        }
        catch (InternalException e) {
            throw new InternalError(e);
        }
        SaasCallbackPayload payload = this.getSaasCallbackPayload(success, message, subscriptionUrl);
        HashMap<String, String> headerFields = new HashMap<String, String>();
        headerFields.put("Accept", APPLICATION_JSON);
        logger.debug("Call saas registry");
        try {
            saasRegistry.createServiceCall().http().put().payload((Object)payload).noPathParameter().noQuery().enhancer(this.serviceSpecification.getRequestEnhancer()).insertHeaderFields(headerFields).end().execute();
        }
        catch (InternalException e) {
            throw new InternalError(e.getCause());
        }
        catch (ServiceException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof InternalError) {
                InternalError internalError = (InternalError)throwable;
                throw internalError;
            }
            throw new InternalError(e.getCause());
        }
    }

    private SaasCallbackPayload getSaasCallbackPayload(boolean success, String message, String subscriptionUrl) {
        SaasCallbackPayload payload = new SaasCallbackPayload();
        payload.message = message;
        payload.status = success ? SUCCEEDED : FAILED;
        payload.subscriptionUrl = subscriptionUrl;
        return payload;
    }

    public ServiceSpecification getServiceSpecification() {
        return this.serviceSpecification;
    }
}

