/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Objects;
import com.sap.cds.Struct;
import com.sap.cds.integration.cloudsdk.rest.client.JsonRestClient;
import com.sap.cds.services.mt.SmsCallback;
import com.sap.cds.services.mt.TenantInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.environment.ServiceBindingUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceIdentifier;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultOAuth2PropertySupplier;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsClient
extends JsonRestClient {
    private static final Logger logger = LoggerFactory.getLogger(SmsClient.class);
    private static final int PAGE_SIZE = 500;
    private static final String SMS = "subscription-manager";
    public static final String BINDING_URL_KEY = "subscription_manager_url";
    public static final String SUBSCRIPTIONS_PATH = "/subscription-manager/v1/subscriptions";
    public static final String SUBSCRIPTION_STATE = "subscriptionState";
    private static final String KEY_SUBSCRIBER = "subscriber";
    private static final String KEY_ZONE_ID = "zoneId";
    private static final String KEY_APP_TID = "app_tid";
    private static final String KEY_SUBACCOUNT_SUBDOMAIN = "subaccountSubdomain";

    public static Optional<ServiceBinding> findBinding(CdsRuntime runtime) {
        return runtime.getEnvironment().getServiceBindings().filter(b -> ServiceBindingUtils.matches((ServiceBinding)b, null, (String)SMS)).findFirst();
    }

    public static TenantInfo toTenantInfo(Map<String, Object> tenant) {
        TenantInfo info = (TenantInfo)Struct.access(tenant).as(TenantInfo.class);
        Map subscriber = (Map)info.get((Object)KEY_SUBSCRIBER);
        String tenantId = (String)subscriber.get(KEY_APP_TID);
        if (tenantId == null) {
            tenantId = (String)subscriber.get(KEY_ZONE_ID);
        }
        info.setTenant(tenantId);
        String subdomain = (String)subscriber.get(KEY_SUBACCOUNT_SUBDOMAIN);
        info.setSubdomain(subdomain);
        return info;
    }

    public SmsClient(ServiceBinding binding) {
        super(ServiceBindingDestinationOptions.forService((ServiceBinding)binding).onBehalfOf(OnBehalfOf.TECHNICAL_USER_PROVIDER).build());
    }

    public void callBackSms(SmsCallback payload, String callbackUrl) throws IOException {
        ObjectNode body = (ObjectNode)this.mapper.convertValue((Object)payload, ObjectNode.class);
        logger.debug("Calling subscription manager");
        this.putRequest(callbackUrl, (JsonNode)body);
    }

    public List<TenantInfo> getSubscribedTenants(UnaryOperator<TenantInfo> filter) throws IOException {
        ArrayList<TenantInfo> result = new ArrayList<TenantInfo>();
        boolean morePages = true;
        int skip = 0;
        while (morePages) {
            logger.debug("Retrieving page {} of all tenants metadata from the Subscription Manager Service", (Object)(skip / 500 + 1));
            String paginatedUrlPath = SmsClient.paginatedUrl(SUBSCRIPTIONS_PATH, skip);
            JsonNode jsonResponse = this.getRequest(paginatedUrlPath);
            ArrayNode resp = (ArrayNode)SmsClient.getNode(jsonResponse, "subscriptions");
            BooleanNode morePagesResp = (BooleanNode)SmsClient.getNode(jsonResponse, "morePages");
            resp.forEach(tenant -> {
                String state;
                String string = state = tenant.get(SUBSCRIPTION_STATE) != null ? tenant.get(SUBSCRIPTION_STATE).asText() : null;
                if (Objects.equal((Object)state, (Object)"SUBSCRIBED") || Objects.equal((Object)state, (Object)"UPDATE_FAILED")) {
                    TenantInfo tenantInfo = SmsClient.toTenantInfo((Map)this.mapper.convertValue(tenant, (TypeReference)new TypeReference<Map<String, Object>>(){}));
                    if (filter != null) {
                        tenantInfo = (TenantInfo)filter.apply(tenantInfo);
                    }
                    result.add(tenantInfo);
                }
            });
            morePages = morePagesResp != null && morePagesResp.booleanValue();
            skip += 500;
            logger.debug("More tenants metadata from the Subscription Manager Service available: {}", (Object)(morePages ? "yes" : "no"));
        }
        return result;
    }

    public List<TenantInfo> getSubscribedTenants() throws IOException {
        return this.getSubscribedTenants(null);
    }

    private static String paginatedUrl(String urlPath, int skip) {
        String url = urlPath + (urlPath.contains("?") ? "&" : "?");
        url = url + "$skip=" + skip + "&$top=500";
        return url;
    }

    private static <N> N getNode(JsonNode jsonResponse, String keyName) {
        return (N)jsonResponse.get(keyName);
    }

    static {
        OAuth2ServiceBindingDestinationLoader.registerPropertySupplier((ServiceIdentifier)ServiceIdentifier.of((String)SMS), OAuth2Supplier::new);
    }

    private static class OAuth2Supplier
    extends DefaultOAuth2PropertySupplier {
        public OAuth2Supplier(ServiceBindingDestinationOptions options) {
            super(options, Collections.emptyList());
        }

        public URI getServiceUri() {
            return (URI)this.getCredentialOrThrow(URI.class, new String[]{SmsClient.BINDING_URL_KEY});
        }
    }
}

