/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.subscription;

import com.sap.cds.adapter.ServletAdapterFactory;
import com.sap.cds.adapter.UrlResourcePath;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;
import com.sap.cds.services.utils.path.UrlPathUtil;
import com.sap.cds.services.utils.path.UrlResourcePathBuilder;

/**
 * Factory for the subscription adapter.
 */
public class SaasProvisioningAdapterFactory implements ServletAdapterFactory, CdsRuntimeAware {

	private CdsRuntime runtime;

	@Override
	public void setCdsRuntime(CdsRuntime runtime) {
		this.runtime = runtime;
	}

	@Override
	public Object create() {
		return new SaasProvisioningServlet(runtime);
	}

	@Override
	public boolean isEnabled() {
		return runtime.getEnvironment().getCdsProperties().getMultiTenancy().getEndpoint().isEnabled();
	}

	@Override
	public String getBasePath() {
		return UrlPathUtil.normalizeBasePath(
				runtime.getEnvironment().getCdsProperties().getMultiTenancy().getEndpoint().getPath());
	}

	@Override
	public String[] getMappings() {
		return new String[] { UrlResourcePathBuilder.path(getBasePath()).recursive().build().getPath() };
	}

	@Override
	public UrlResourcePath getServletPath() {
		// mt endpoints always need authentication
		return UrlResourcePathBuilder.path(getBasePath()).recursive().isPublic(false).build();
	}

}
