package com.sap.cds.feature.mt;

import com.google.common.annotations.Beta;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsProvider;

/**
 * Determines the database schema ID for the given {@link UserInfo} context.
 * By default CAP uses the tenant ID ({@link UserInfo#getTenant()}) as database schema ID.
 * This provider allows adjusting the mapping from {@link UserInfo} to database schema ID.
 * Most commonly this is used in shared tenancy scenarios with discriminator column to allow
 * multiple tenants to be mapped to the same database schema ID.
 */
@Beta
public interface DatabaseSchemaIdProvider extends CdsProvider<DatabaseSchemaIdProvider> {

	/**
	 * Returns the database schema ID for the given {@link UserInfo} context.
	 * @param userInfo the {@link UserInfo}
	 * @param forBinding the name of the binding (from which the multitenant DataSource was created)
	 * @return the database schema ID
	 */
	String get(UserInfo userInfo, String forBinding);

}
