/*******************************************************************************
 *   © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/

package com.sap.cds.feature.mt.lib.runtime;

import com.sap.cds.feature.mt.lib.subscription.DataSourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.Connection;
import java.sql.SQLException;

public class GenericConnectionProvider implements ConnectionProvider {
	private static Logger logger = LoggerFactory.getLogger(GenericConnectionProvider.class);

	@Override
	public Connection getConnection(String tenantId, DataSourceAndInfo dataSourceAndInfo) throws SQLException {
		DataSourceInfo info = dataSourceAndInfo.getDataSourceInfo();
		Connection connection = dataSourceAndInfo.getDataSource().getConnection();//NOSONAR
		logger.debug("Set schema to {}", info.getSchema());
		try {
			connection.setSchema(info.getSchema());
			if (!connection.getSchema().equals(info.getSchema())) {
				throw new SQLException("Could not set schema " + info.getSchema());
			}
		} catch (SQLException sqlException) {
			connection.close();
			throw sqlException;
		}
		return connection;
	}
}
