/*******************************************************************************
 *   © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cds.feature.mt.lib.runtime;

import java.sql.Connection;
import java.sql.SQLException;

public class SchemalessConnectionProvider implements ConnectionProvider {

	@Override
	public Connection getConnection(String tenantId, DataSourceAndInfo dataSourceAndInfo) throws SQLException {
		// For SQLite, the driver does not allow to manage the schema (it is always null)
		return dataSourceAndInfo.getDataSource().getConnection();
	}
}
