/*******************************************************************************
 *   © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cds.feature.mt.lib.runtime;

import com.sap.cds.feature.mt.lib.subscription.DataSourceInfo;
import com.sap.cds.feature.mt.lib.subscription.InstanceLifecycleManager;
import com.sap.cds.feature.mt.lib.subscription.exceptions.InternalError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.sql.DataSource;

public class TomcatDataSourceLookup extends DataSourceLookup {
	private static Logger logger = LoggerFactory.getLogger(TomcatDataSourceLookup.class);
	private final EnvironmentAccess environment;
	private final DataPoolSettings poolSettings;
	private final boolean registerJmx;


	public TomcatDataSourceLookup(InstanceLifecycleManager instanceLifecycleManager, EnvironmentAccess environment,
								  DataPoolSettings poolSettings, boolean oneDataSourcePerDb,
								  boolean registerJmx) {
		super(instanceLifecycleManager, oneDataSourcePerDb);
		this.environment = environment;
		this.poolSettings = poolSettings;
		this.registerJmx = registerJmx;
	}

	public TomcatDataSourceLookup(InstanceLifecycleManager instanceLifecycleManager, EnvironmentAccess environment,
								  DataPoolSettings poolSettings, boolean oneDataSourcePerDb) {
		this(instanceLifecycleManager, environment, poolSettings, oneDataSourcePerDb, false);
	}

	@Override
	public DataSource create(DataSourceInfo info) throws InternalError {
		DataSourceCreator dataSourceCreator = null;
		logger.debug("Tomcat pooling data source taken");
		dataSourceCreator = new DataSourceCreatorTomcat(poolSettings, registerJmx);
		return dataSourceCreator.create(info, environment);
	}

	@Override
	public void closeDataSource(DataSource dataSource) {
		if (dataSource == null) {
			return;
		}
		logger.debug("Close Tomcat pooling data source");
		org.apache.tomcat.jdbc.pool.DataSource tomcatDataSource = (org.apache.tomcat.jdbc.pool.DataSource) dataSource;
		tomcatDataSource.close();
	}
}

