/*******************************************************************************
 *   © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/

package com.sap.cds.feature.mt.lib.subscription;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DbIdentifiersHana implements DbIdentifiers {
	private final Set<String> dbIds = ConcurrentHashMap.newKeySet();

	public DbIdentifiersHana(Set<String> dbIds) {
		if (dbIds != null) {
			this.dbIds.addAll(dbIds);
		}
	}

	public DbIdentifiersHana(DbIdentifiersHana dbIdentifiers) {
		this(dbIdentifiers != null ? dbIdentifiers.getDbIds() : null);
	}

	public Set<String> getDbIds() {
		return Collections.unmodifiableSet(dbIds);
	}

	public void add(String dbId) {
		dbIds.add(dbId);
	}

	public void remove(String dbId) {
		dbIds.remove(dbId);
	}

	@Override
	public boolean areSet() {
		return dbIds != null && !dbIds.isEmpty();
	}

	@Override
	public DB getDB() {
		return DB.HANA;
	}

	@Override
	public DbIdentifiers createCopy() {
		return new DbIdentifiersHana(this);
	}
}
