/*******************************************************************************
 *   © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/

package com.sap.cds.feature.mt.lib.subscription;


import com.sap.cds.services.utils.lib.tools.api.ResilienceConfig;

public class DynamicHdiDeploymentParameters {
	private final String user;
	private final String password;
	private final PollingParameters polling;
	private final ResilienceConfig resilienceConfig;
	private final String url;

	public DynamicHdiDeploymentParameters(String url, String user,
										  String password, PollingParameters polling, ResilienceConfig resilienceConfig) {
		this.url = url;
		this.user = user;
		this.password = password;
		this.polling = polling != null ? polling : PollingParameters.DEFAULT;
		this.resilienceConfig = resilienceConfig != null ? resilienceConfig : ResilienceConfig.NONE;
	}

	public String getUser() {
		return user;
	}

	public String getPassword() {
		return password;
	}

	public PollingParameters getPolling() {
		return polling;
	}

	public ResilienceConfig getResilienceConfig() {
		return resilienceConfig;
	}

	public String getUrl() {
		return url;
	}
}
