/*******************************************************************************
 *   © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cds.feature.mt.lib.subscription;

import java.util.HashMap;
import java.util.Map;

/**
 * Service binding parameters
 */
public class ServiceOperation extends HashMap<String, Object> {
	public static final String STATE = "state";
	public static final String TYPE = "type";

	public ServiceOperation(Map<String, ?> m) {
		super(!m.isEmpty() ? m : new HashMap<String, Object>());
	}

	public String getId() {
		return (String) get("id");
	}

	public boolean isReady() {
		return containsKey("ready") && (boolean) get("ready");
	}

	public String getState() {
		return (String) get(STATE);
	}

	public String getResourceId() {
		return (String) get("resource_id");
	}

	public String getResourceType() {
		return (String) get("resource_type");
	}

	public String getCreatedAt() {
		return (String) get("created_at");
	}

	public String getUpdatedAt() {
		return (String) get("updated_at");
	}

	@SuppressWarnings("unchecked")
	public Map<String, Object> getErrors() {
		return (Map<String, Object>) get("errors");
	}

	public Type getType() {
		if (!containsKey(TYPE)) {
			return Type.UNDEFINED;
		}
		return switch ((String) get(TYPE)) {
			case "create" -> Type.CREATE;
			case "delete" -> Type.DELETE;
			case "update" -> Type.UPDATE;
			default -> Type.UNDEFINED;
		};
	}

	public Status getStatus() {
		if (!containsKey(STATE)) {
			return Status.IN_PROGRESS;
		}
		return switch ((String) get(STATE)) {
			case "succeeded" -> Status.SUCCEEDED;
			case "failed" -> Status.FAILED;
			default -> Status.IN_PROGRESS;
		};
	}

	public enum Status {
		SUCCEEDED, FAILED, IN_PROGRESS, UNDEFINED
	}

	public enum Type {
		CREATE, DELETE, UPDATE, UNDEFINED
	}
}
