/*******************************************************************************
 *   © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cds.feature.mt.lib.subscription.exits;

import com.sap.cds.feature.mt.lib.subscription.json.DeletePayload;

public interface UnSubscribeExit {
	default Boolean onBeforeUnsubscribe(String tenantId, DeletePayload deletePayload) {
		return false;
	}

	default Boolean onBeforeAsyncUnsubscribe(String tenantId, DeletePayload deletePayload) {
		return false;
	}

	default void onAfterUnsubscribe(String tenantId, DeletePayload deletePayload) {
	}

	default void onAfterAsyncUnsubscribe(String tenantId, DeletePayload deletePayload) {
	}
}
